/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.CombatLifeCycleAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class MoltenAffix
extends CombatLifeCycleAffix {
    @Override
    public void onSpawn(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 40, 0, true, false));
        if (livingEntity instanceof Mob) {
            Mob mobEntity = (Mob)livingEntity;
            mobEntity.m_21441_(BlockPathTypes.WATER, -1.0f);
            mobEntity.m_21441_(BlockPathTypes.LAVA, 8.0f);
            mobEntity.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
            mobEntity.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
            try {
                Set goals = mobEntity.f_21345_.m_148105_();
                Iterator iter = goals.iterator();
                while (iter.hasNext()) {
                    WrappedGoal goal = (WrappedGoal)iter.next();
                    Goal baseGoal = goal.m_26015_();
                    if (!(baseGoal instanceof FleeSunGoal) && !(baseGoal instanceof RestrictSunGoal)) continue;
                    iter.remove();
                }
            }
            catch (Exception e) {
                Champions.LOGGER.error("Error accessing goals!");
            }
            if (mobEntity.m_21573_() instanceof GroundPathNavigation) {
                ((GroundPathNavigation)mobEntity.m_21573_()).m_26490_(false);
            }
        }
    }

    @Override
    public void onServerUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        if (livingEntity.f_19797_ % 20 == 0) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 40, 0, true, false));
            if (!ChampionsConfig.moltenWaterResistance && livingEntity.m_20070_()) {
                Holder.Reference drown = livingEntity.m_9236_().m_9598_().m_255025_(Registries.f_268580_).m_255043_(DamageTypes.f_268722_);
                livingEntity.m_6469_(new DamageSource((Holder)drown), 1.0f);
            }
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        target.m_20254_(10);
        DamageSource inFire = new DamageSources(target.m_9236_().m_9598_()).m_269387_();
        target.m_6469_(inFire, amount);
        return true;
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().setCategory(AffixCategory.OFFENSE).build();
    }
}

