/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BaseBulletEntity
extends Projectile {
    @Nullable
    private Entity finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public BaseBulletEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public BaseBulletEntity(EntityType<? extends Projectile> type, Level level, LivingEntity livingEntity, @Nonnull Entity entity, Direction.Axis axis) {
        this(type, level);
        this.m_5602_((Entity)livingEntity);
        BlockPos blockpos = livingEntity.m_20183_();
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 0.5;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        this.m_7678_(d0, d1, d2, this.m_146908_(), this.m_146909_());
        this.finalTarget = entity;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(axis);
    }

    @Nonnull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_7380_(@Nonnull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.finalTarget != null) {
            pCompound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        if (this.currentMoveDirection != null) {
            pCompound.m_128405_("Dir", this.currentMoveDirection.m_122411_());
        }
        pCompound.m_128405_("Steps", this.flightSteps);
        pCompound.m_128347_("TXD", this.targetDeltaX);
        pCompound.m_128347_("TYD", this.targetDeltaY);
        pCompound.m_128347_("TZD", this.targetDeltaZ);
    }

    protected void m_7378_(@Nonnull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.flightSteps = pCompound.m_128451_("Steps");
        this.targetDeltaX = pCompound.m_128459_("TXD");
        this.targetDeltaY = pCompound.m_128459_("TYD");
        this.targetDeltaZ = pCompound.m_128459_("TZD");
        if (pCompound.m_128425_("Dir", 99)) {
            this.currentMoveDirection = Direction.m_122376_((int)pCompound.m_128451_("Dir"));
        }
        if (pCompound.m_128403_("Target")) {
            this.targetId = pCompound.m_128342_("Target");
        }
    }

    protected void m_8097_() {
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction pDirection) {
        this.currentMoveDirection = pDirection;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis p_37349_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.finalTarget == null) {
            blockpos = this.m_20183_().m_7495_();
        } else {
            d0 = (double)this.finalTarget.m_20206_() * 0.5;
            blockpos = new BlockPos(this.finalTarget.m_146903_(), (int)((double)this.finalTarget.m_146904_() + d0), this.finalTarget.m_146907_());
        }
        double d1 = (double)blockpos.m_123341_() + 0.5;
        double d2 = (double)blockpos.m_123342_() + d0;
        double d3 = (double)blockpos.m_123343_() + 0.5;
        Direction direction = null;
        if (!this.closerToCenterThan(blockpos, (Position)this.m_20182_(), 2.0)) {
            BlockPos blockpos1 = this.m_20183_();
            ArrayList list = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if (blockpos1.m_123341_() < blockpos.m_123341_() && this.m_9236_().m_46859_(blockpos1.m_122029_())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.m_123341_() > blockpos.m_123341_() && this.m_9236_().m_46859_(blockpos1.m_122024_())) {
                    list.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if (blockpos1.m_123342_() < blockpos.m_123342_() && this.m_9236_().m_46859_(blockpos1.m_7494_())) {
                    list.add(Direction.UP);
                } else if (blockpos1.m_123342_() > blockpos.m_123342_() && this.m_9236_().m_46859_(blockpos1.m_7495_())) {
                    list.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if (blockpos1.m_123343_() < blockpos.m_123343_() && this.m_9236_().m_46859_(blockpos1.m_122019_())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.m_123343_() > blockpos.m_123343_() && this.m_9236_().m_46859_(blockpos1.m_122012_())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.m_235672_((RandomSource)this.f_19796_);
            if (list.isEmpty()) {
                for (int i = 5; !this.m_9236_().m_46859_(blockpos1.m_121945_(direction)) && i > 0; --i) {
                    direction = Direction.m_235672_((RandomSource)this.f_19796_);
                }
            } else {
                direction = (Direction)list.get(this.f_19796_.m_188503_(list.size()));
            }
            d1 = this.m_20185_() + (double)direction.m_122429_();
            d2 = this.m_20186_() + (double)direction.m_122430_();
            d3 = this.m_20189_() + (double)direction.m_122431_();
        }
        this.setMoveDirection(direction);
        double d6 = d1 - this.m_20185_();
        double d7 = d2 - this.m_20186_();
        double d4 = d3 - this.m_20189_();
        double d5 = Math.sqrt(d6 * d6 + d7 * d7 + d4 * d4);
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.f_19812_ = true;
        this.flightSteps = 10 + this.f_19796_.m_188503_(5) * 10;
    }

    private boolean closerToCenterThan(BlockPos pos, Position position, double distance) {
        return this.distToCenterSqr(pos, position.m_7096_(), position.m_7098_(), position.m_7094_()) < Mth.m_144952_((double)distance);
    }

    private double distToCenterSqr(BlockPos pos, double x, double y, double z) {
        double d0 = (double)pos.m_123341_() + 0.5 - x;
        double d1 = (double)pos.m_123342_() + 0.5 - y;
        double d2 = (double)pos.m_123343_() + 0.5 - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            HitResult hitresult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.m_14008_((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.m_14008_((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.m_14008_((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_((this.targetDeltaX - vec3.f_82479_) * 0.2, (this.targetDeltaY - vec3.f_82480_) * 0.2, (this.targetDeltaZ - vec3.f_82481_) * 0.2));
            }
            if ((hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
        }
        this.m_20101_();
        Vec3 vec31 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec31.f_82479_, this.m_20186_() + vec31.f_82480_, this.m_20189_() + vec31.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_(this.getParticle(), this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.15, this.m_20189_() - vec31.f_82481_, 0.0, 0.0, 0.0);
        } else if (this.finalTarget != null && !this.finalTarget.m_213877_()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.m_122434_());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos blockpos = this.m_20183_();
                Direction.Axis direction$axis = this.currentMoveDirection.m_122434_();
                if (this.m_9236_().m_46575_(blockpos.m_121945_(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(direction$axis);
                } else {
                    BlockPos blockpos1 = this.finalTarget.m_20183_();
                    if (direction$axis == Direction.Axis.X && blockpos.m_123341_() == blockpos1.m_123341_() || direction$axis == Direction.Axis.Z && blockpos.m_123343_() == blockpos1.m_123343_() || direction$axis == Direction.Axis.Y && blockpos.m_123342_() == blockpos1.m_123342_()) {
                        this.selectNextMoveDirection(direction$axis);
                    }
                }
            }
        }
    }

    protected boolean m_5603_(@Nonnull Entity pTarget) {
        return super.m_5603_(pTarget) && !pTarget.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return pDistance < 16384.0;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected void m_5790_(@Nonnull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity != this.m_19749_() && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.bulletEffect(target);
        }
    }

    protected void m_8060_(@Nonnull BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
            this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
        }
    }

    protected void m_6532_(@Nonnull HitResult pResult) {
        super.m_6532_(pResult);
        this.m_146870_();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(@Nonnull DamageSource pSource, float pAmount) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.m_146870_();
        }
        return true;
    }

    public void m_141965_(@Nonnull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        double d0 = pPacket.m_131503_();
        double d1 = pPacket.m_131504_();
        double d2 = pPacket.m_131505_();
        this.m_20334_(d0, d1, d2);
    }

    protected abstract void bulletEffect(LivingEntity var1);

    protected abstract ParticleOptions getParticle();
}

