/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.event.customEvent.ChampionsEventHooks;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.network.SPacketSyncAffixSetting;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModParticleTypes;
import top.theillusivec4.champions.common.stat.ChampionsStats;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.Utils;
import top.theillusivec4.champions.server.command.ChampionsCommand;

public class ChampionEventsHandler {
    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)Champions.API.getAffixDataLoader());
        event.addListener((PreparableReloadListener)Champions.API.getAttributesModifierDataLoader());
    }

    @SubscribeEvent
    public void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
            int growth = rank.getGrowthFactor();
            if (growth > 0) {
                evt.setDroppedExperience(growth * ChampionsConfig.experienceGrowth * evt.getOriginalExperience() + evt.getDroppedExperience());
            }
        }));
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start evt) {
        Explosion explosion = evt.getExplosion();
        Entity entity = explosion.getExploder();
        if (entity != null && !entity.m_9236_().m_5776_()) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
                int growth = rank.getGrowthFactor();
                if (growth > 0) {
                    explosion.f_46017_ += (float)(ChampionsConfig.explosionGrowth * growth);
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingJoinWorld(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.m_9236_().m_5776_() && ChampionHelper.isValidChampionEntity(entity)) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Optional<Rank> maybeRank = serverChampion.getRank();
                if (maybeRank.isEmpty()) {
                    if (!ChampionsEventHooks.onAttemptChampionSpawn(champion)) {
                        evt.setCanceled(true);
                        return;
                    }
                    ChampionBuilder.spawn(champion);
                }
                Utils.consumeIfLifeCycle(serverChampion.getAffixes(), lifecycle -> lifecycle.onSpawn((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                    effects.forEach(effectPair -> champion.getLivingEntity().m_7292_(new MobEffectInstance((MobEffect)((Holder)effectPair.m_14418_()).get(), 200, ((Integer)effectPair.m_14419_()).intValue())));
                });
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.EntityInteract event) {
        if (ChampionsConfig.enableDebug) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            if (!target.m_9236_().m_5776_() && ChampionHelper.isChampionEntity(target)) {
                ChampionCapability.getCapability(target).ifPresent(ChampionBuilder::resetAndUpdate);
                player.m_213846_((Component)Component.m_237113_((String)"[Debug] Removed %s rank, affixes and attribute modifiers".formatted(target.m_7755_().getString())));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity.m_9236_().m_5776_()) {
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Client clientChampion = champion.getClient();
                if (ChampionHelper.isValidChampion(clientChampion)) {
                    Utils.consumeIfLifeCycle(clientChampion.getAffixes(), lifecycle -> lifecycle.onClientUpdate((IChampion)champion));
                    clientChampion.getRank().ifPresent(rank -> {
                        if (ChampionsConfig.showParticles && (Integer)rank.m_14418_() > 0) {
                            String colorCode = (String)rank.m_14419_();
                            int color = Rank.getColor(colorCode);
                            float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
                            float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
                            float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
                            livingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.RANK_PARTICLE_TYPE.get(), livingEntity.m_20182_().f_82479_ + (livingEntity.m_217043_().m_188500_() - 0.5) * (double)livingEntity.m_20205_(), livingEntity.m_20182_().f_82480_ + livingEntity.m_217043_().m_188500_() * (double)livingEntity.m_20206_(), livingEntity.m_20182_().f_82481_ + (livingEntity.m_217043_().m_188500_() - 0.5) * (double)livingEntity.m_20205_(), (double)r, (double)g, (double)b);
                        }
                    });
                }
            });
        } else if (livingEntity.f_19797_ % 10 == 0) {
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    Utils.consumeIfLifeCycle(serverChampion.getAffixes(), lifecycle -> lifecycle.onServerUpdate((IChampion)champion));
                    serverChampion.getRank().ifPresent(rank -> {
                        if (livingEntity.f_19797_ % 4 == 0) {
                            List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                            effects.forEach(effectPair -> livingEntity.m_7292_(new MobEffectInstance((MobEffect)((Holder)effectPair.m_14418_()).get(), 100, ((Integer)effectPair.m_14419_()).intValue())));
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity.m_9236_().m_5776_()) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            if (ChampionHelper.isValidChampion(serverChampion)) {
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    if (!combatAffix.onAttacked((IChampion)champion, evt.getSource(), evt.getAmount())) {
                        evt.setCanceled(true);
                    }
                });
            }
        });
        if (evt.isCanceled()) {
            return;
        }
        Entity source = evt.getSource().m_7640_();
        ChampionCapability.getCapability(source).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            if (ChampionHelper.isValidChampion(serverChampion)) {
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    if (!combatAffix.onAttack((IChampion)champion, evt.getEntity(), evt.getSource(), evt.getAmount())) {
                        evt.setCanceled(true);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.m_9236_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    amounts[1] = combatAffix.onHurt((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.m_9236_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    amounts[1] = combatAffix.onDamage((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity.m_9236_().m_5776_()) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                if (!combatAffix.onDeath((IChampion)champion, evt.getSource())) {
                    evt.setCanceled(true);
                }
            });
            serverChampion.getRank().ifPresent(rank -> {
                Entity source;
                if (!evt.isCanceled() && (source = evt.getSource().m_7639_()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)source;
                    if (!(source instanceof FakePlayer)) {
                        MinecraftServer server;
                        player.m_36220_(ChampionsStats.CHAMPION_MOBS_KILLED);
                        int messageTier = ChampionsConfig.deathMessageTier;
                        if (messageTier > 0 && rank.getTier() >= messageTier && (server = livingEntity.m_20194_()) != null) {
                            server.m_6846_().m_240416_((Component)Component.m_237115_((String)("rank.champions.title." + rank.getTier())).m_130946_(" ").m_7220_(livingEntity.m_21231_().m_19293_()), false);
                        }
                    }
                }
            });
        });
    }

    @SubscribeEvent
    public void onServerStart(ServerAboutToStartEvent evt) {
        ChampionHelper.setServer(evt.getServer());
    }

    @SubscribeEvent
    public void onServerClose(ServerStoppedEvent evt) {
        ChampionHelper.setServer(null);
        ChampionHelper.clearBeacons();
    }

    @SubscribeEvent
    public void onBeaconStart(AttachCapabilitiesEvent<BlockEntity> evt) {
        BlockEntity blockEntity = (BlockEntity)evt.getObject();
        if (blockEntity instanceof BeaconBlockEntity) {
            ChampionHelper.addBeacon(blockEntity.m_58899_());
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.m_9236_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    amounts[1] = combatAffix.onHeal((IChampion)champion, amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onBossBarEvent(CustomizeGuiOverlayEvent.BossEventProgress evt) {
        if (ChampionsOverlay.isRendering) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        List relevantPlayers = event.getPlayers();
        SPacketSyncAffixSetting syncAffixSetting = new SPacketSyncAffixSetting(Champions.API.getAffixDataLoader().getLoadedData());
        SPacketSyncAffixSetting.handelSettingMainThread();
        relevantPlayers.forEach(player -> NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncAffixSetting));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        ChampionsCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }
}

