/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.event.customEvent.ChampionsEventHooks;
import top.theillusivec4.champions.common.integration.gamestages.GameStagesPlugin;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionData;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.common.util.Utils;

public class ChampionBuilder {
    private static final RandomSource RAND = RandomSource.m_216343_();

    public static void spawn(IChampion champion) {
        if (ChampionData.read(champion)) {
            return;
        }
        LivingEntity entity = champion.getLivingEntity();
        Rank newRank = ChampionBuilder.createRank(entity);
        if (newRank != null && newRank.getTier() >= 1) {
            if (!ChampionsEventHooks.onPreChampionSpawn(champion)) {
                return;
            }
            champion.getServer().setRank(newRank);
            ChampionBuilder.applyGrowth(champion, newRank.getGrowthFactor());
            List<IAffix> newAffixes = ChampionBuilder.createAffixes(newRank, champion);
            champion.getServer().setAffixes(newAffixes);
            Utils.consumeIfLifeCycle(newAffixes, lifecycle -> lifecycle.onInitialSpawn(champion));
            ChampionsEventHooks.onPostChampionSpawn(champion);
        }
    }

    public static void spawnPreset(IChampion champion, int tier, List<IAffix> affixes) {
        Rank newRank = RankManager.getRank(tier);
        champion.getServer().setRank(newRank);
        ChampionBuilder.applyGrowth(champion, newRank.getGrowthFactor());
        affixes = affixes.isEmpty() ? ChampionBuilder.createAffixes(newRank, champion) : affixes;
        champion.getServer().setAffixes(affixes);
        Utils.consumeIfLifeCycle(affixes, lifecycle -> lifecycle.onInitialSpawn(champion));
    }

    public static List<IAffix> createAffixes(Rank rank, IChampion champion) {
        int size = rank.getNumAffixes();
        ArrayList<IAffix> affixesToAdd = new ArrayList<IAffix>();
        Optional<EntityManager.EntitySettings> entitySettings = EntityManager.getSettings(champion.getLivingEntity().m_6095_());
        if (size > 0) {
            entitySettings.ifPresent(settings -> {
                if (settings.presetAffixes != null) {
                    affixesToAdd.addAll(settings.presetAffixes);
                }
            });
            rank.getPresetAffixes().forEach(affix -> {
                if (!affixesToAdd.contains(affix)) {
                    affixesToAdd.add((IAffix)affix);
                }
            });
        }
        Map<AffixCategory, List<IAffix>> allAffixes = Champions.API.getCategoryMap();
        HashMap<AffixCategory, List<IAffix>> validAffixes = new HashMap<AffixCategory, List<IAffix>>();
        for (AffixCategory category : Champions.API.getCategories()) {
            validAffixes.put(category, new ArrayList());
        }
        allAffixes.forEach((k, v) -> ((List)validAffixes.get(k)).addAll(v.stream().filter(affix -> !affixesToAdd.contains(affix) && entitySettings.map(entitySettings1 -> entitySettings1.canApply((IAffix)affix)).orElse(true) != false && affix.canApply(champion)).toList()));
        ChampionBuilder.addAffixToList(size, affixesToAdd, validAffixes, RAND);
        return affixesToAdd;
    }

    public static Rank createRank(LivingEntity livingEntity) {
        if (ChampionHelper.notPotential(livingEntity)) {
            return RankManager.getEmptyRank();
        }
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        if (ranks.isEmpty()) {
            Champions.LOGGER.error("No rank configuration found! Please check the 'champions-ranks.toml' file in the 'serverconfigs'.");
            return RankManager.getEmptyRank();
        }
        int[] tierRange = new int[]{(Integer)ranks.firstKey(), (Integer)ranks.lastKey()};
        EntityManager.getSettings(livingEntity.m_6095_()).ifPresent(entitySettings -> {
            if (entitySettings.minTier != null) {
                tierRange[0] = entitySettings.minTier;
            }
            if (entitySettings.maxTier != null) {
                tierRange[1] = entitySettings.maxTier;
            }
        });
        int minTier = tierRange[0];
        int maxTier = tierRange[1];
        ImmutableSortedMap filteredRanks = (ImmutableSortedMap)ranks.subMap((Object)minTier, true, (Object)maxTier, true).entrySet().stream().filter(entry -> !Utils.isGameStagesLoaded() || GameStagesPlugin.hasTierStage((Integer)entry.getKey(), livingEntity)).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Map.Entry::getKey, Map.Entry::getValue));
        if (filteredRanks.isEmpty()) {
            Champions.LOGGER.warn("No valid ranks found in the specified range! Assigning EmptyRank to {}", (Object)livingEntity);
            return RankManager.getEmptyRank();
        }
        int totalWeight = filteredRanks.values().stream().mapToInt(Rank::getWeight).sum();
        if (totalWeight <= 0) {
            Champions.LOGGER.warn("All ranks have zero weight! Assigning EmptyRank to {}", (Object)livingEntity);
            return RankManager.getEmptyRank();
        }
        int randomValue = RAND.m_188503_(totalWeight);
        int cumulativeWeight = 0;
        for (Rank rank : filteredRanks.values()) {
            if (randomValue >= (cumulativeWeight += rank.getWeight())) continue;
            return rank;
        }
        return RankManager.getEmptyRank();
    }

    public static void applyGrowth(IChampion champion, float growthFactor) {
        LivingEntity livingEntity = champion.getLivingEntity();
        if (growthFactor != 0.0f) {
            Champions.API.getAttributesModifierDataLoader().getLoadedData().forEach((identifier, value) -> {
                if (value.enable()) {
                    Optional attribute = ForgeRegistries.ATTRIBUTES.getDelegate(value.attributeType());
                    Pair<Double, AttributeModifier.Operation> setting = value.setting();
                    Boolean matches = value.modifierCondition().map(championModifierCondition -> championModifierCondition.test(champion)).orElse(true);
                    if (matches.booleanValue()) {
                        attribute.ifPresent(attributeValue -> ChampionBuilder.applyAttributeModifier(livingEntity, (Holder.Reference<Attribute>)attributeValue, identifier, setting, growthFactor));
                    }
                }
            });
        }
    }

    public static void resetChampionModifiers(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        PlayerList playerList = Objects.requireNonNull(livingEntity.m_20194_()).m_6846_();
        Champions.API.getAttributesModifierDataLoader().getLoadedData().forEach((identifier, value) -> {
            if (value.enable()) {
                Optional attribute = ForgeRegistries.ATTRIBUTES.getDelegate(value.attributeType());
                Boolean matches = value.modifierCondition().map(championModifierCondition -> championModifierCondition.test(champion)).orElse(true);
                if (matches.booleanValue()) {
                    attribute.ifPresent(attributeValue -> {
                        AttributeInstance attributeInstance = livingEntity.m_21204_().m_246600_((Holder)attributeValue);
                        if (attributeInstance != null) {
                            attributeInstance.m_22122_().forEach(attributeModifier -> {
                                boolean isChampionModifier = attributeModifier.m_22214_().contains("champions");
                                if (isChampionModifier) {
                                    attributeInstance.m_22127_(attributeModifier.m_22209_());
                                    if (ChampionsConfig.enableDebug) {
                                        String debugInfo = "Removed champion modifier: UUID: %s Name:%s Operation: %s".formatted(attributeModifier.m_22209_(), attributeModifier.m_22214_(), attributeModifier.m_22217_());
                                        Champions.LOGGER.debug(debugInfo);
                                        playerList.m_11314_().stream().filter(p -> p.m_20310_(2)).forEach(serverPlayer -> serverPlayer.m_213846_((Component)Component.m_237113_((String)debugInfo)));
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public static void resetAndUpdate(IChampion champion) {
        ChampionBuilder.resetAndUpdate(champion, true, true, true);
    }

    public static void resetAndUpdate(IChampion champion, boolean resetGrowth, boolean resetRank, boolean resetAffix) {
        IChampion.Server serverChampion = champion.getServer();
        LivingEntity targetEntity = champion.getLivingEntity();
        if (resetGrowth) {
            ChampionBuilder.resetChampionModifiers(champion);
        }
        if (resetRank) {
            serverChampion.setRank(RankManager.getEmptyRank());
        }
        if (resetAffix) {
            serverChampion.setAffixes(List.of());
        }
        if (resetAffix || resetRank) {
            NetworkHandler.syncChampionDataToPlayerTrackingEntity(serverChampion, targetEntity);
        }
    }

    private static void applyAttributeModifier(LivingEntity livingEntity, Holder.Reference<Attribute> attributeValue, ResourceLocation modifierId, Pair<Double, AttributeModifier.Operation> setting, float growthFactor) {
        ChampionBuilder.applyAttributeModifier(livingEntity, attributeValue, UUID.randomUUID(), ChampionBuilder.getAttributeFormated(modifierId), (Double)setting.getFirst() * (double)growthFactor, (AttributeModifier.Operation)setting.getSecond());
    }

    private static ResourceLocation getAttributeFormated(ResourceLocation modifierId) {
        return Utils.getLocation(modifierId.m_135827_() + "_" + modifierId.m_135815_().split("\\.json")[0] + "_modifier");
    }

    public static void applyAttributeModifier(LivingEntity livingEntity, Holder<Attribute> attribute, UUID modifierUuid, ResourceLocation modifierName, double amount, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = livingEntity.m_21204_().m_246600_(attribute);
        AttributeModifier attributeModifier = new AttributeModifier(modifierUuid, modifierName.toString(), amount, operation);
        if (attributeInstance != null && !attributeInstance.m_22109_(attributeModifier)) {
            attributeInstance.m_22125_(attributeModifier);
            if (attributeInstance.m_22099_() == Attributes.f_22276_) {
                livingEntity.m_21153_(livingEntity.m_21233_());
            }
        }
    }

    public static void copy(IChampion oldChampion, IChampion newChampion) {
        IChampion.Server oldServer = oldChampion.getServer();
        IChampion.Server newServer = newChampion.getServer();
        Rank rank = oldServer.getRank().orElse(RankManager.getLowestRank());
        newServer.setRank(rank);
        ChampionBuilder.applyGrowth(newChampion, rank.getGrowthFactor());
        List<IAffix> oldAffixes = oldChampion.getServer().getAffixes();
        newServer.setAffixes(oldAffixes);
        Utils.consumeIfLifeCycle(newServer.getAffixes(), lifecycle -> {
            lifecycle.onInitialSpawn(newChampion);
            lifecycle.onSpawn(newChampion);
        });
    }

    public static void addAffixToList(int size, List<IAffix> toModifier, Map<AffixCategory, List<IAffix>> validAffixes, RandomSource rand) {
        ArrayList randomList = new ArrayList();
        validAffixes.forEach((k, v) -> randomList.addAll(v));
        while (!randomList.isEmpty() && toModifier.size() < size) {
            int randomIndex = rand.m_188503_(randomList.size());
            IAffix randomAffix = (IAffix)randomList.get(randomIndex);
            if (toModifier.stream().allMatch(affix -> affix.isCompatible(randomAffix) && (randomAffix.getCategory() == AffixCategory.OFFENSE || affix.getCategory() != randomAffix.getCategory()))) {
                toModifier.add(randomAffix);
            }
            randomList.remove(randomIndex);
        }
    }
}

