/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.FaunifyConfig;
import com.pepper.faunify.entity.HedgehogEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class HedgehogModel
extends DefaultedEntityGeoModel<HedgehogEntity> {
    public HedgehogModel() {
        super(new ResourceLocation("faunify", "hedgehog"), true);
    }

    public ResourceLocation getAnimationResource(HedgehogEntity object) {
        if (((Boolean)FaunifyConfig.OLD_ANIMATION.get()).booleanValue()) {
            return new ResourceLocation("faunify", "animations/hedgehog.animation.json");
        }
        return new ResourceLocation("faunify", "animations/rathedgehog.animation.json");
    }

    public void setCustomAnimations(HedgehogEntity entity, long uniqueID, AnimationState<HedgehogEntity> animationState) {
        CoreGeoBone head;
        if (!entity.m_5803_() && !entity.isCurledUp()) {
            if (!this.turnsHead) {
                return;
            }
            head = this.getAnimationProcessor().getBone("head");
            if (head != null) {
                EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
                head.setRotX(entityData.headPitch() * 0.3f * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * 0.3f * ((float)Math.PI / 180));
            }
        }
        if (entity.m_5803_()) {
            return;
        }
        head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone neck = this.getAnimationProcessor().getBone("head_rotation");
        boolean moving = animationState.isMoving();
        if (neck != null && head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * 0.3f * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * 0.3f * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * 0.3f * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

