/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.entity.HedgehogEntity;
import com.pepper.faunify.entity.client.model.HedgehogModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class HedgehogRenderer
extends GeoEntityRenderer<HedgehogEntity> {
    private static final ResourceLocation LIGHT = new ResourceLocation("faunify", "textures/entity/hedgehog1.png");
    private static final ResourceLocation DARK = new ResourceLocation("faunify", "textures/entity/hedgehog2.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("faunify", "textures/entity/hedgehog3.png");
    private static final ResourceLocation SONIC = new ResourceLocation("faunify", "textures/entity/hedgehog_sonic.png");
    private static final ResourceLocation SHADOW = new ResourceLocation("faunify", "textures/entity/hedgehog_shadow.png");
    private static final ResourceLocation LIGHT_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/hedgehog1.png");
    private static final ResourceLocation DARK_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/hedgehog2.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/hedgehog3.png");
    private static final ResourceLocation SONIC_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/hedgehog_sonic.png");
    private static final ResourceLocation SHADOW_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/hedgehog_shadow.png");

    public HedgehogRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new HedgehogModel());
        this.f_114477_ = 0.3f;
    }

    public ResourceLocation getTextureLocation(HedgehogEntity entity) {
        String entityName = entity.m_7755_().getString().toLowerCase();
        if ("sonic".equals(entityName)) {
            return entity.m_5803_() ? SONIC_SLEEPING : SONIC;
        }
        if ("shadow".equals(entityName)) {
            return entity.m_5803_() ? SHADOW_SLEEPING : SHADOW;
        }
        return HedgehogRenderer.getVariantTexture(entity.getVariant(), entity.m_5803_());
    }

    public static ResourceLocation getVariantTexture(HedgehogEntity.Variant variant, boolean isSleeping) {
        return switch (variant) {
            case HedgehogEntity.Variant.LIGHT -> isSleeping ? LIGHT_SLEEPING : LIGHT;
            case HedgehogEntity.Variant.DARK -> isSleeping ? DARK_SLEEPING : DARK;
            case HedgehogEntity.Variant.ALBINO -> isSleeping ? ALBINO_SLEEPING : ALBINO;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static ResourceLocation getVariantTexture(HedgehogEntity.Variant variant) {
        return HedgehogRenderer.getVariantTexture(variant, false);
    }

    public void preRender(PoseStack stack, HedgehogEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.6f;
            stack.m_85841_(babyScale, babyScale, babyScale);
        } else {
            float adultScale = 0.9f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

