/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.objects.GuiFluidObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.client.utils.FluidTextureType;
import org.zeith.hammerlib.util.java.Suppliers2;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="fluid")
public class FlowguiFluidReader
extends GuiReader<GuiFluidObject> {
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Required(value="minecraft:water")
    public static final String KEY_FLUID = "fluid";
    @AllowJS
    @AllowedValues(value={})
    public static final String KEY_FLUID_STACK = "fluid-stack";
    @AllowJS
    @AllowedValues(value={"^0*[1-9]\\d*$"})
    @Required(value="1000")
    public static final String KEY_COUNT = "count";
    @AllowJS
    @AllowedValues(value={"^0*[1-9]\\d*$"})
    @Required(value="1000")
    public static final String KEY_CAPACITY = "capacity";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    public static final String KEY_HOVERABLE = "hoverable";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    public static final String KEY_OFFER_INGREDIENT = "offer-ingredient";
    @AllowJS
    @AllowedValues(value={"^still|flow|flowing$"})
    @Suggestions(value={"still", "flowing"})
    public static final String KEY_FLUID_TEXTURE = "fluid-texture";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    public static final String KEY_SHOW_CAPACITY = "show-capacity";
    @AllowJS
    public static final String KEY_NBT = "nbt";

    @Override
    protected GuiFluidObject readObject(KeyMap map, String name, IDataNode node) {
        boolean dynCount;
        java.util.function.Supplier<FluidStack> finalFactory;
        AtomicReference<GuiFluidObject> self = new AtomicReference<GuiFluidObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        if (node.keys().contains(KEY_FLUID_STACK)) {
            finalFactory = Suppliers2.map(ComDrivers.readObject(ctx, KEY_FLUID_STACK, FluidStack.class), f -> {
                if (f == null) {
                    f = FluidStack.EMPTY;
                }
                return f;
            });
            dynCount = true;
        } else {
            java.util.function.Supplier<String> itemIdFactory = ComDrivers.readString(ctx, KEY_FLUID);
            java.util.function.Supplier<String> tagFactory = ComDrivers.readString(ctx, KEY_NBT);
            boolean constant = ComDrivers.isConstant(itemIdFactory) && ComDrivers.isConstant(tagFactory);
            Supplier primaryFactory = () -> {
                FluidStack fluid = new FluidStack((Fluid)BuiltInRegistries.f_257020_.m_7745_(Resources.location((String)itemIdFactory.get())), 1);
                String tag = (String)tagFactory.get();
                if (tag != null && !tag.isBlank()) {
                    try {
                        fluid.setTag(TagParser.m_129359_((String)tag));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                return fluid;
            };
            Supplier intermFactory = constant ? Suppliers.memoize(() -> primaryFactory.get()) : primaryFactory;
            AtomicInteger count = new AtomicInteger(1);
            finalFactory = () -> FlowguiFluidReader.lambda$readObject$2((java.util.function.Supplier)intermFactory, count);
            dynCount = ComDrivers.driveInt(ctx, KEY_COUNT, 1, false, count::set);
        }
        GuiFluidObject o = new GuiFluidObject(name, finalFactory);
        self.set(o);
        ComDrivers.driveInt(ctx, KEY_CAPACITY, 1, dynCount, o::capacity);
        ComDrivers.driveBool(ctx, KEY_HOVERABLE, false, false, o::hoverable);
        ComDrivers.driveBool(ctx, KEY_OFFER_INGREDIENT, false, false, o::provideIngredient);
        ComDrivers.driveString(ctx, KEY_FLUID_TEXTURE, "still", false, t -> o.textureType((FluidTextureType)((Object)((Object)MoreObjects.firstNonNull((Object)((Object)FluidTextureType.fromString(t)), (Object)((Object)FluidTextureType.STILL))))));
        ComDrivers.driveBool(ctx, KEY_SHOW_CAPACITY, false, false, o::showCapacity);
        return o;
    }

    private static /* synthetic */ FluidStack lambda$readObject$2(java.util.function.Supplier intermFactory, AtomicInteger count) {
        FluidStack stack = (FluidStack)intermFactory.get();
        stack.setAmount(count.get());
        return stack;
    }
}

