/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.scans;

import java.lang.annotation.ElementType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.ProvideRecipes;
import org.zeith.hammerlib.api.IRecipeProvider;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class ScanRecipes {
    public static IScanListener create() {
        return IAnnotationScanListener.forAnnotation(ProvideRecipes.class, ElementType.TYPE, ScanRecipes::handle);
    }

    private static void handle(ScanDataHelper.ModAwareAnnotationData data) {
        FMLModContainer ow = data.getOwnerMod().orElse(null);
        if (ow == null) {
            HammerLib.LOG.info("Skipping mod-less @ProvideRecipes annotation in {}", (Object)data.clazz());
            return;
        }
        Class<?> c = data.getOwnerClass();
        if (!IRecipeProvider.class.isAssignableFrom(c)) {
            HammerLib.LOG.error("@ProvideRecipes {} does not implement {}", c, IRecipeProvider.class);
            return;
        }
        IRecipeProvider provider = (IRecipeProvider)UnsafeHacks.newInstance(c);
        if (provider == null) {
            return;
        }
        IEventBus bus = ow.getEventBus();
        if (bus == null) {
            HammerLib.LOG.warn("Skipping registration of {} since we couldn't find relevant mod bus.", (Object)data.clazz());
            return;
        }
        bus.addListener(provider::provideRecipes);
        bus.addListener(provider::spoofRecipes);
    }
}

