/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.zeith.hammerlib.util.mcf.TagRegistrationContext;

public class BuildTagsEvent
extends Event {
    private static final Object IO_SYNC = new Object();
    public final String directory;
    public final Map<ResourceLocation, List<TagLoader.EntryWithSource>> tags;
    public final ForgeRegistry reg;
    private final Map<String, TagRegistrationContext> contextMap = Maps.newHashMap();

    public BuildTagsEvent(ForgeRegistry reg, String directory, Map<ResourceLocation, List<TagLoader.EntryWithSource>> tags) {
        this.reg = reg;
        this.directory = directory;
        this.tags = tags;
    }

    public <T> void addToTag(TagKey<T> key, T value) {
        TagLoader.EntryWithSource te = this.valueToEntry(value);
        if (te == null) {
            return;
        }
        ResourceLocation id = te.f_216042_().getId();
        if (!this.getContext(id.m_135827_()).addToTag(key, id)) {
            return;
        }
        this.tags.computeIfAbsent(key.f_203868_(), k -> new ArrayList()).add(te);
    }

    public <T> void addAllToTag(TagKey<T> key, Collection<T> values) {
        ResourceLocation path = key.f_203868_();
        List regTag = this.tags.computeIfAbsent(path, k -> new ArrayList());
        for (T value : values) {
            ResourceLocation id;
            TagLoader.EntryWithSource te = this.valueToEntry(value);
            if (te == null || !this.getContext((id = te.f_216042_().getId()).m_135827_()).addToTag(key, id)) continue;
            regTag.add(te);
        }
    }

    protected TagRegistrationContext getContext(String modid) {
        return this.contextMap.computeIfAbsent(modid, m -> {
            Object object = IO_SYNC;
            synchronized (object) {
                return TagRegistrationContext.load(m);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void cleanup() {
        Object object = IO_SYNC;
        synchronized (object) {
            for (TagRegistrationContext value : this.contextMap.values()) {
                value.save();
            }
        }
        this.contextMap.clear();
    }

    public TagLoader.EntryWithSource valueToEntry(Object value) {
        ResourceLocation key = this.reg.getKey(value);
        if (key == null) {
            return null;
        }
        return new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)key), "Default");
    }

    public String toString() {
        return "BuildTagsEvent<" + this.reg.getRegistryKey().m_135782_() + ">{directory=" + this.directory + "}";
    }
}

