/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;

public class PhantomInkRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<PhantomInkRecipe> SERIALIZER = new NoOpRecipeSerializer<PhantomInkRecipe>(PhantomInkRecipe::new);

    public PhantomInkRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer var1, @NotNull Level var2) {
        boolean foundInk = false;
        boolean foundItem = false;
        for (int i = 0; i < var1.m_6643_(); ++i) {
            ItemStack stack = var1.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(BotaniaItems.phantomInk) && !foundInk) {
                foundInk = true;
                continue;
            }
            if (!foundItem) {
                if (stack.m_41720_() instanceof PhantomInkable && !stack.m_41720_().m_41470_()) {
                    foundItem = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundInk && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack item = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PhantomInkable) || !item.m_41619_()) continue;
            item = stack;
        }
        PhantomInkable inkable = (PhantomInkable)item.m_41720_();
        ItemStack copy = item.m_41777_();
        inkable.setPhantomInk(copy, !inkable.hasPhantomInk(item));
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

