/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.flower.functional.SolegnoliaBlockEntity;
import vazkii.botania.common.config.ConfigDataManagerImpl;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RingOfLokiItem;

public class BotaniaAPIImpl
implements BotaniaAPI {
    private ConfigDataManager configDataManager = new ConfigDataManagerImpl();
    private final Map<ResourceLocation, Function<DyeColor, Block>> paintableBlocks = new ConcurrentHashMap<ResourceLocation, Function<DyeColor, Block>>();

    @Override
    public int apiVersion() {
        return 2;
    }

    @Override
    @Nullable
    public Registry<Brew> getBrewRegistry() {
        return (Registry)BuiltInRegistries.f_257047_.m_7745_(BotaniaRegistries.BREWS.m_135782_());
    }

    @Override
    public net.minecraft.world.item.ArmorMaterial getManasteelArmorMaterial() {
        return ArmorMaterial.MANASTEEL;
    }

    @Override
    public net.minecraft.world.item.ArmorMaterial getElementiumArmorMaterial() {
        return ArmorMaterial.ELEMENTIUM;
    }

    @Override
    public net.minecraft.world.item.ArmorMaterial getManaweaveArmorMaterial() {
        return ArmorMaterial.MANAWEAVE;
    }

    @Override
    public net.minecraft.world.item.ArmorMaterial getTerrasteelArmorMaterial() {
        return ArmorMaterial.TERRASTEEL;
    }

    @Override
    public Tier getManasteelItemTier() {
        return ItemTier.MANASTEEL;
    }

    @Override
    public Tier getElementiumItemTier() {
        return ItemTier.ELEMENTIUM;
    }

    @Override
    public Tier getTerrasteelItemTier() {
        return ItemTier.TERRASTEEL;
    }

    @Override
    public ManaNetwork getManaNetworkInstance() {
        return ManaNetworkHandler.instance;
    }

    @Override
    public Container getAccessoriesInventory(Player player) {
        return EquipmentHandler.getAllWorn((LivingEntity)player);
    }

    @Override
    public void breakOnAllCursors(Player player, ItemStack stack, BlockPos pos, Direction side) {
        RingOfLokiItem.breakOnAllCursors(player, stack, pos, side);
    }

    @Override
    public boolean hasSolegnoliaAround(Entity e) {
        return SolegnoliaBlockEntity.hasSolegnoliaAround(e);
    }

    @Override
    public void sparkleFX(Level world, double x, double y, double z, float r, float g, float b, float size, int m) {
        SparkleParticleData data = SparkleParticleData.sparkle(size, r, g, b, m);
        world.m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public Map<ResourceLocation, Function<DyeColor, Block>> getPaintableBlocks() {
        return Collections.unmodifiableMap(this.paintableBlocks);
    }

    @Override
    public void registerPaintableBlock(ResourceLocation block, Function<DyeColor, Block> transformer) {
        this.paintableBlocks.put(block, transformer);
    }

    @Override
    public void registerCorporeaNodeDetector(CorporeaNodeDetector detector) {
        CorporeaNodeDetectors.register(detector);
    }

    @Override
    public ConfigDataManager getConfigData() {
        return this.configDataManager;
    }

    @Override
    public void setConfigData(ConfigDataManager configDataManager) {
        this.configDataManager = configDataManager;
    }

    private static enum ArmorMaterial implements net.minecraft.world.item.ArmorMaterial
    {
        MANASTEEL("manasteel", 16, Map.of(ArmorItem.Type.BOOTS, 2, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.HELMET, 2), 18, () -> BotaniaSounds.equipManasteel, () -> BotaniaItems.manaSteel, 0.0f),
        MANAWEAVE("manaweave", 5, Map.of(ArmorItem.Type.BOOTS, 1, ArmorItem.Type.LEGGINGS, 2, ArmorItem.Type.CHESTPLATE, 3, ArmorItem.Type.HELMET, 1), 18, () -> BotaniaSounds.equipManaweave, () -> BotaniaItems.manaweaveCloth, 0.0f),
        ELEMENTIUM("elementium", 18, Map.of(ArmorItem.Type.BOOTS, 2, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.HELMET, 2), 18, () -> BotaniaSounds.equipElementium, () -> BotaniaItems.elementium, 0.0f),
        TERRASTEEL("terrasteel", 34, Map.of(ArmorItem.Type.BOOTS, 3, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.CHESTPLATE, 8, ArmorItem.Type.HELMET, 3), 26, () -> BotaniaSounds.equipTerrasteel, () -> BotaniaItems.terrasteel, 3.0f);

        private final String name;
        private final int durabilityMultiplier;
        private final Map<ArmorItem.Type, Integer> damageReduction;
        private final int enchantability;
        private final Supplier<SoundEvent> equipSound;
        private final Supplier<Item> repairItem;
        private final float toughness;

        private ArmorMaterial(String name, int durabilityMultiplier, Map<ArmorItem.Type, Integer> damageReduction, int enchantability, Supplier<SoundEvent> equipSound, Supplier<Item> repairItem, float toughness) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.damageReduction = damageReduction;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairItem = repairItem;
            this.toughness = toughness;
        }

        public int m_266425_(ArmorItem.Type slot) {
            int base = switch (slot) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS -> 13;
                case ArmorItem.Type.LEGGINGS -> 15;
                case ArmorItem.Type.CHESTPLATE -> 16;
                case ArmorItem.Type.HELMET -> 11;
            };
            return this.durabilityMultiplier * base;
        }

        public int m_7366_(ArmorItem.Type slot) {
            return this.damageReduction.get(slot);
        }

        public int m_6646_() {
            return this.enchantability;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return this.equipSound.get();
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.repairItem.get()});
        }

        @NotNull
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }

    private static enum ItemTier implements Tier
    {
        MANASTEEL(300, 6.2f, 2.0f, 3, 20, () -> BotaniaItems.manaSteel),
        ELEMENTIUM(720, 6.2f, 2.0f, 3, 20, () -> BotaniaItems.elementium),
        TERRASTEEL(2300, 9.0f, 4.0f, 4, 26, () -> BotaniaItems.terrasteel);

        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int harvestLevel;
        private final int enchantability;
        private final Supplier<Item> repairItem;

        private ItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<Item> repairItem) {
            this.maxUses = maxUses;
            this.efficiency = efficiency;
            this.attackDamage = attackDamage;
            this.harvestLevel = harvestLevel;
            this.enchantability = enchantability;
            this.repairItem = repairItem;
        }

        public int m_6609_() {
            return this.maxUses;
        }

        public float m_6624_() {
            return this.efficiency;
        }

        public float m_6631_() {
            return this.attackDamage;
        }

        public int m_6604_() {
            return this.harvestLevel;
        }

        public int m_6601_() {
            return this.enchantability;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.repairItem.get()});
        }
    }
}

