/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.loot.BotaniaLootTables;

public class LooniumEquipmentLootProvider
implements DataProvider {
    public static final int COLOR_ENDERMAN_BODY = 0x1D1D21;
    public static final int COLOR_TIDE_LEATHER = 1481884;
    public static final int COLOR_EVOKER_COAT = 3290681;
    public static final int COLOR_VINDICATOR_BOOTS = 3290681;
    public static final int COLOR_VINDICATOR_JACKET = 4673362;
    public static final int COLOR_VINDICATOR_LEGWEAR = 1477772;
    public static final int COLOR_ILLUSIONER_COAT = 3898306;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registryLookupFuture;

    public LooniumEquipmentLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.registryLookupFuture = registryLookupFuture;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        return this.registryLookupFuture.thenCompose(registryLookup -> this.run(cache, (HolderLookup.Provider)registryLookup));
    }

    private CompletableFuture<?> run(@NotNull CachedOutput cache, HolderLookup.Provider registryLookup) {
        HolderLookup.RegistryLookup patternRegistry = registryLookup.m_255025_(Registries.f_266063_);
        HolderLookup.RegistryLookup materialRegistry = registryLookup.m_255025_(Registries.f_266076_);
        BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory = (pattern, material) -> LooniumEquipmentLootProvider.getTrim((HolderLookup.RegistryLookup<TrimPattern>)patternRegistry, (HolderLookup.RegistryLookup<TrimMaterial>)materialRegistry, (ResourceKey<TrimPattern>)pattern, (ResourceKey<TrimMaterial>)material);
        BiConsumer<ArmorTrim, CompoundTag> trimSetter = (trim, tag) -> LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).accept((CompoundTag)tag);
        BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory = (trim, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim), true, (Item)armorItems);
        TriFunction randomizedDyedSetFactory = (trim, color, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).andThen(LooniumEquipmentLootProvider.addDyedColorToTag(color)), true, (Item)armorItems);
        TriFunction fixedDyedSetFactory = (trim, color, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).andThen(LooniumEquipmentLootProvider.addDyedColorToTag(color)), false, (Item)armorItems);
        Map<ArmorMaterials, Item[]> armorItems2 = Map.of(ArmorMaterials.LEATHER, new Item[]{Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_}, ArmorMaterials.CHAIN, new Item[]{Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_}, ArmorMaterials.IRON, new Item[]{Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_}, ArmorMaterials.GOLD, new Item[]{Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_}, ArmorMaterials.DIAMOND, new Item[]{Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_}, ArmorMaterials.NETHERITE, new Item[]{Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_});
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        this.defineWeaponEquipmentTables(tables);
        this.defineAncientCityEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineBastionRemnantEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineDesertPyramidEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineEndCityEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineJungleTempleEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineFortressEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineOceanMonumentEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory, (TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder>)randomizedDyedSetFactory);
        this.definePillagerOutpostEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineRuinedPortalEquipmentTables(tables);
        this.defineShipwreckEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineStrongholdEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory, trimSetter);
        this.defineTrailRuinsEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineWoodlandMansionEquipmentTables(tables, trimFactory, (TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder>)fixedDyedSetFactory, trimSetter);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(tables.size());
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.m_245731_((ResourceLocation)e.getKey());
            LootTable.Builder builder = (LootTable.Builder)e.getValue();
            LootTable lootTable = builder.m_79165_(LootContextParamSets.f_81413_).m_79167_();
            JsonElement jsonTree = Deserializers.m_78800_().create().toJsonTree((Object)lootTable);
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void defineWeaponEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables) {
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42386_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42433_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_BOW, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42411_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42717_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42383_).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42388_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42430_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42713_))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_AXE).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(new NbtPredicate(this.getProfessionNbt(VillagerProfession.f_35587_)))))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42387_).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(new NbtPredicate(this.getProfessionNbt(VillagerProfession.f_35590_)))))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42523_).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(new NbtPredicate(this.getProfessionNbt(VillagerProfession.f_35591_)))))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42385_).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(new NbtPredicate(this.getProfessionNbt(VillagerProfession.f_35598_)))))).m_79076_(LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(new NbtPredicate(this.getProfessionNbt(VillagerProfession.f_35599_))))))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)-1.0f, (float)1.0f)).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42425_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42411_))));
    }

    private CompoundTag getProfessionNbt(VillagerProfession profession) {
        CompoundTag villagerDataTag = new CompoundTag();
        BuiltInRegistries.f_256735_.m_194605_().encodeStart((DynamicOps)NbtOps.f_128958_, (Object)profession).resultOrPartial(arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0)).ifPresent(data -> villagerDataTag.m_128365_("profession", data));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("VillagerData", (Tag)villagerDataTag);
        return tag;
    }

    private void defineAncientCityEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimWardQuartz = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266074_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265905_);
        ArmorTrim trimSilenceCopper = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_276510_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265969_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON, randomizedSetFactory.apply(trimWardQuartz, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND, randomizedSetFactory.apply(trimWardQuartz, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD, randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND, randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag darknessEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.f_216964_, 200);
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON).m_79707_(11)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND).m_79707_(1))).m_79161_(LootPool.m_79043_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42411_}).m_45077_()).m_32207_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)darknessEffectTag)))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
    }

    private void defineBastionRemnantEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSnoutGold = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266083_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265937_);
        ArmorTrim trimSnoutNetherite = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266083_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265896_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD, randomizedSetFactory.apply(trimSnoutNetherite, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE, randomizedSetFactory.apply(trimSnoutGold, armorItems.get(ArmorMaterials.NETHERITE)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT))));
    }

    private void defineDesertPyramidEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimDuneRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_265941_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265870_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID))));
    }

    private void defineEndCityEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSpireAmethyst = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_265976_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265872_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag levitationEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.f_19620_, 200);
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_END_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND).m_79707_(2))).m_79161_(LootPool.m_79043_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_((EntityType)EntityType.f_20524_)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)levitationEffectTag)))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_END_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_END_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_END_CITY))));
    }

    private static CompoundTag getPotionEffectTag(MobEffect mobEffect, int duration) {
        ListTag effects = new ListTag();
        effects.add((Object)new MobEffectInstance(mobEffect, duration).m_19555_(new CompoundTag()));
        CompoundTag effectTag = new CompoundTag();
        effectTag.m_128365_("CustomPotionEffects", (Tag)effects);
        effectTag.m_128405_("CustomPotionColor", mobEffect.m_19484_());
        return effectTag;
    }

    private void defineFortressEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimRibIron = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266089_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266000_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_FORTRESS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON).m_79707_(7)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND).m_79707_(2))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_FORTRESS))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_FORTRESS))));
    }

    private void defineJungleTempleEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimWildEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266087_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266071_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
    }

    private void defineOceanMonumentEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory, TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder> randomizedDyedSetFactory) {
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER, (LootTable.Builder)randomizedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266069_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265969_), (Object)1481884, (Object)armorItems.get(ArmorMaterials.LEATHER)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD, randomizedSetFactory.apply(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266069_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266027_), armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND, randomizedSetFactory.apply(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266069_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265937_), armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
    }

    private void definePillagerOutpostEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSentryEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_265866_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266071_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_OUTPOST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_OUTPOST))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_OUTPOST))));
    }

    private void defineRuinedPortalEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables) {
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_PORTAL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42476_)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42477_)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42478_)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42479_)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_PORTAL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))));
        tables.put(BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_PORTAL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD))));
    }

    private void defineShipwreckEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimCoastEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_265901_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266071_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
    }

    private void defineStrongholdEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory, BiConsumer<ArmorTrim, CompoundTag> trimSetter) {
        ArmorTrim trimEyeRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266091_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265870_);
        ArmorTrim trimEyeLapis = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266091_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265981_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON, randomizedSetFactory.apply(trimEyeLapis, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD, randomizedSetFactory.apply(trimEyeRedstone, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND, randomizedSetFactory.apply(trimEyeLapis, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag endermanHeadTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266091_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265872_), endermanHeadTag);
        LooniumEquipmentLootProvider.addDyedColorToTag(0x1D1D21).accept(endermanHeadTag);
        CompoundTag endermanBodyTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(0x1D1D21).accept(endermanBodyTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42407_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)endermanHeadTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)endermanBodyTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)endermanBodyTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)endermanBodyTag)))));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN).m_79707_(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
    }

    private void defineTrailRuinsEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimHostEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_276573_, (ResourceKey<TrimMaterial>)TrimMaterials.f_266071_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN, randomizedSetFactory.apply(trimHostEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON, randomizedSetFactory.apply(trimHostEmerald, armorItems.get(ArmorMaterials.IRON)));
        ArmorTrim trimRaiserAmethyst = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_276435_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265872_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON, randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD, randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(ArmorMaterials.GOLD)));
        ArmorTrim trimShaperLapis = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_276604_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265981_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD, randomizedSetFactory.apply(trimShaperLapis, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND, randomizedSetFactory.apply(trimShaperLapis, armorItems.get(ArmorMaterials.DIAMOND)));
        ArmorTrim trimWayfinderRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_276615_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265870_);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN, randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND, randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN).m_79707_(7)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN).m_79707_(7)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON).m_79707_(8)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON).m_79707_(8)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND).m_79707_(2))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
    }

    private void defineWoodlandMansionEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder> fixedDyedSetFactory, BiConsumer<ArmorTrim, CompoundTag> trimSetter) {
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER, ((LootTable.Builder)fixedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266039_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265937_), (Object)3290681, (Object)new Item[]{Items.f_42408_, Items.f_42462_})).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42747_))));
        CompoundTag vindicatorChestTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266039_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265896_), vindicatorChestTag);
        LooniumEquipmentLootProvider.addDyedColorToTag(4673362).accept(vindicatorChestTag);
        CompoundTag vindicatorLegsTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(1477772).accept(vindicatorLegsTag);
        CompoundTag vindicatorBootsTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(3290681).accept(vindicatorBootsTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)vindicatorChestTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)vindicatorLegsTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)vindicatorBootsTag)))).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42386_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))))));
        CompoundTag blindnessEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.f_19610_, 100);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER, ((LootTable.Builder)fixedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266039_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265981_), (Object)3898306, (Object)new Item[]{Items.f_42407_, Items.f_42408_, Items.f_42462_})).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42411_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))))).m_79161_(LootPool.m_79043_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_((EntityType)EntityType.f_20524_)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)blindnessEffectTag)))));
        CompoundTag vexHeadTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.f_266039_, (ResourceKey<TrimMaterial>)TrimMaterials.f_265872_), vexHeadTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42472_).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)vexHeadTag)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42473_))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42474_))).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42383_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f))))));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_MANSION, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER).m_79707_(1)).m_79076_(LootTableReference.m_79776_((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX).m_79707_(45).m_79080_((LootItemCondition.Builder)AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.m_81927_((float)0.005f), LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33717_(Boolean.valueOf(true)).m_33716_()))})))).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42747_))));
    }

    private static ArmorTrim getTrim(HolderLookup.RegistryLookup<TrimPattern> patternRegistry, HolderLookup.RegistryLookup<TrimMaterial> materialRegistry, ResourceKey<TrimPattern> pattern, ResourceKey<TrimMaterial> material) {
        Holder.Reference tidePattern = (Holder.Reference)patternRegistry.m_254902_(pattern).orElseThrow();
        Holder.Reference goldMaterial = (Holder.Reference)materialRegistry.m_254902_(material).orElseThrow();
        return new ArmorTrim((Holder)goldMaterial, (Holder)tidePattern);
    }

    private static Consumer<CompoundTag> addTrimToTag(HolderLookup.Provider registryLookup, ArmorTrim trim) {
        return tag -> tag.m_128365_("Trim", (Tag)ArmorTrim.f_265985_.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryLookup), (Object)trim).result().orElseThrow());
    }

    private static Consumer<CompoundTag> addDyedColorToTag(int color) {
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128405_("color", color);
        return tag -> tag.m_128365_("display", (Tag)displayTag);
    }

    private LootTable.Builder createArmorSet(Consumer<CompoundTag> tagModifier, boolean randomized, Item ... armorItems) {
        CompoundTag tag = new CompoundTag();
        tagModifier.accept(tag);
        LootTable.Builder lootTable = LootTable.m_79147_();
        for (Item armorItem : armorItems) {
            lootTable.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)(randomized ? UniformGenerator.m_165780_((float)0.0f, (float)1.0f) : ConstantValue.m_165692_((float)1.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)armorItem).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag))));
        }
        return lootTable;
    }

    @NotNull
    public String m_6055_() {
        return "Equipment tables for Loonium-spawned mobs";
    }
}

