/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.SpectatorItem;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;
import vazkii.botania.test.TestingUtil;

public class SpectatorScanTest {
    private static final BlockPos POSITION_CHEST_NORMAL = new BlockPos(17, 16, 16);
    private static final BlockPos POSITION_CHEST_LOOT = new BlockPos(15, 16, 16);
    private static final BlockPos POSITION_CART_NORMAL = new BlockPos(11, 2, 6);
    private static final BlockPos POSITION_CART_LOOT = new BlockPos(9, 2, 6);
    private static final BlockPos POSITION_ITEM = new BlockPos(7, 3, 3);
    private static final BlockPos POSITION_VILLAGER = new BlockPos(4, 2, 3);
    private static final BlockPos POSITION_DONKEY = new BlockPos(19, 2, 6);
    private static final BlockPos POSITION_ALLAY = new BlockPos(19, 2, 16);
    private static final String LOOT_TABLE_CHEST = "minecraft:chests/simple_dungeon";
    private static final String LOOT_TABLE_CART = "minecraft:chests/abandoned_mineshaft";

    @GameTest(template="botania:item/spectator_scan", batch="spectator1")
    public void testSpectatorScanMainHand(GameTestHelper helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> player.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42416_)));
    }

    @GameTest(template="botania:item/spectator_scan", batch="spectator2")
    public void testSpectatorScanOffHand(GameTestHelper helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> player.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42416_)));
    }

    @GameTest(template="botania:item/spectator_scan", batch="spectator3")
    public void testSpectatorScanBothHands(GameTestHelper helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> {
            player.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42416_));
            player.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42416_));
        });
    }

    private static void performTest(GameTestHelper helper, BiConsumer<GameTestHelper, Player> additionalSetup) {
        helper.m_177301_();
        ItemEntity itemEntity = helper.m_246755_(Items.f_42416_, POSITION_ITEM);
        Villager villager = (Villager)helper.m_177176_(EntityType.f_20492_, POSITION_VILLAGER);
        villager.m_34375_(new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35598_, 2));
        MinecartChest regularChestCart = (MinecartChest)helper.m_177176_(EntityType.f_20470_, POSITION_CART_NORMAL);
        regularChestCart.m_6836_(2, new ItemStack((ItemLike)Items.f_42413_));
        regularChestCart.m_6836_(5, new ItemStack((ItemLike)Items.f_42416_));
        ChestBlockEntity regularChest = (ChestBlockEntity)TestingUtil.assertBlockEntity(helper, POSITION_CHEST_NORMAL, BlockEntityType.f_58918_);
        regularChest.m_6836_(3, new ItemStack((ItemLike)Items.f_42484_));
        regularChest.m_6836_(7, new ItemStack((ItemLike)Items.f_42416_));
        Donkey donkey = (Donkey)helper.m_177329_(EntityType.f_20560_, POSITION_DONKEY);
        donkey.m_30651_(true);
        donkey.m_30504_(true);
        ((AbstractHorseAccessor)donkey).botania_createInventory();
        SimpleContainer donkeyInventory = ((AbstractHorseAccessor)donkey).getInventory();
        donkeyInventory.m_6836_(3, new ItemStack((ItemLike)Items.f_42413_));
        donkeyInventory.m_6836_(4, new ItemStack((ItemLike)Items.f_42416_));
        Allay allay = (Allay)helper.m_177329_(EntityType.f_217014_, POSITION_ALLAY);
        allay.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42416_));
        MinecartChest lootChestCart = (MinecartChest)helper.m_177176_(EntityType.f_20470_, POSITION_CART_LOOT);
        lootChestCart.m_38236_(new ResourceLocation(LOOT_TABLE_CART), 1L);
        ChestBlockEntity lootChest = (ChestBlockEntity)TestingUtil.assertBlockEntity(helper, POSITION_CHEST_LOOT, BlockEntityType.f_58918_);
        lootChest.m_59626_(new ResourceLocation(LOOT_TABLE_CHEST), 1L);
        Player player = helper.m_177368_();
        player.m_20219_(helper.m_177227_(new Vec3(24.0, 24.0, 24.0)));
        additionalSetup.accept(helper, player);
        ItemStack spectatorStack = new ItemStack((ItemLike)BotaniaItems.itemFinder);
        ((SpectatorItem)BotaniaItems.itemFinder).scanForItems(spectatorStack, player);
        TestingUtil.assertThat(lootChestCart.m_214142_() != null, () -> "Chest loot was rolled");
        TestingUtil.assertThat(((RandomizableContainerBlockEntityAccessor)lootChest).getLootTable() != null, () -> "Chest loot was rolled");
        long[] blocks = ItemNBTHelper.getLongArray(spectatorStack, "highlightPositionsBlock");
        TestingUtil.assertEquals(blocks.length, 1, () -> "Expected 1 block hit, was " + blocks.length);
        BlockPos chestPos = BlockPos.m_122022_((long)blocks[0]);
        TestingUtil.assertEquals(helper.m_177449_(POSITION_CHEST_NORMAL), chestPos, () -> "Chest position " + String.valueOf(helper.m_177449_(POSITION_CHEST_NORMAL)) + " not in result, but found " + String.valueOf(chestPos));
        int[] entities = ItemNBTHelper.getIntArray(spectatorStack, "highlightPositionsEnt");
        TestingUtil.assertEquals(entities.length, 5, () -> "Expected 5 entity hits, but got " + entities.length);
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> villager.m_19879_() == id), () -> "Villager not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> itemEntity.m_19879_() == id), () -> "Item entity not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> regularChestCart.m_19879_() == id), () -> "Minecart not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> donkey.m_19879_() == id), () -> "Donkey not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> allay.m_19879_() == id), () -> "Allay not in result");
        helper.m_177301_();
        helper.m_177412_();
    }
}

