/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.razz.essentialpartnermod.EssentialPartner;
import com.razz.essentialpartnermod.PartnerModConfig;
import com.razz.essentialpartnermod.data.ModalData;
import com.razz.essentialpartnermod.data.PartnerModData;
import com.razz.essentialpartnermod.loader.EssentialPartnerLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;

public class EssentialAPI {
    private static final String API_BASE_URL = System.getProperty("essential.partnermod.api", "https://api.essential.gg");
    private static final String MOD_PARTNER_DATA_URL = API_BASE_URL + "/v1/mod-partner";
    private static final String USER_AGENT = "EssentialPartnerMod/" + EssentialPartnerLoader.OUR_VERSION + " (" + EssentialPartnerLoader.OUR_PKG + ")";
    private static final Path API_CACHE_FILE = PartnerModConfig.CONFIG_FOLDER.resolve("data.cache.json");
    private static final Path API_OVERRIDE_FILE = PartnerModConfig.CONFIG_FOLDER.resolve("data.override.json");
    private static final Path MODAL_OVERRIDE_FOLDER = PartnerModConfig.CONFIG_FOLDER.resolve("override");
    private static final Path MODAL_OVERRIDE_FILE = MODAL_OVERRIDE_FOLDER.resolve("mod-partner-modal-metadata.json");

    public static CompletableFuture<PartnerModData> fetchPartnerModData() {
        CompletableFuture<PartnerModData> future = new CompletableFuture<PartnerModData>();
        CompletableFuture.runAsync(() -> {
            try {
                String response;
                if (Files.exists(API_OVERRIDE_FILE, new LinkOption[0])) {
                    EssentialPartner.LOGGER.info("Using API override file");
                    try (BufferedReader reader = Files.newBufferedReader(API_OVERRIDE_FILE);){
                        PartnerModData data = (PartnerModData)EssentialPartner.GSON.fromJson((Reader)reader, PartnerModData.class);
                        future.complete(data);
                        return;
                    }
                    catch (Exception e) {
                        EssentialPartner.LOGGER.error("Failed to load api override", (Throwable)e);
                    }
                }
                HttpURLConnection connection = (HttpURLConnection)URI.create(MOD_PARTNER_DATA_URL).toURL().openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.addRequestProperty("User-Agent", USER_AGENT);
                connection.connect();
                try (InputStream is = connection.getInputStream();){
                    response = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(API_CACHE_FILE, new OpenOption[0]);){
                    writer.write(response);
                }
                catch (Exception e) {
                    EssentialPartner.LOGGER.error("Failed to write cached response", (Throwable)e);
                }
                PartnerModData data = (PartnerModData)EssentialPartner.GSON.fromJson(response, PartnerModData.class);
                if (Files.exists(MODAL_OVERRIDE_FILE, new LinkOption[0])) {
                    EssentialPartner.LOGGER.info("Using modal override folder");
                    try (BufferedReader reader = Files.newBufferedReader(MODAL_OVERRIDE_FILE);){
                        ModalData modalData = (ModalData)EssentialPartner.GSON.fromJson((Reader)reader, ModalData.class);
                        for (ModalData.Feature feature : modalData.getFeatures()) {
                            Path iconPath = MODAL_OVERRIDE_FOLDER.resolve(feature.getIcon());
                            try {
                                byte[] bytes = Files.readAllBytes(iconPath);
                                String base64 = Base64.getEncoder().encodeToString(bytes);
                                feature.setIcon(base64);
                            }
                            catch (IOException e) {
                                EssentialPartner.LOGGER.error("Failed to load icon {}", (Object)iconPath, (Object)e);
                            }
                        }
                        data = new PartnerModData(modalData, data.getPartneredMods());
                    }
                    catch (Exception e) {
                        EssentialPartner.LOGGER.error("Failed to load modal override", (Throwable)e);
                    }
                }
                future.complete(data);
            }
            catch (Exception e) {
                EssentialPartner.LOGGER.error("Failed to fetch modal data", (Throwable)e);
                try {
                    future.complete(EssentialAPI.getFallbackData());
                }
                catch (Exception e2) {
                    EssentialPartner.LOGGER.error("Failed to load fallback modal data", (Throwable)e2);
                    future.completeExceptionally(e2);
                }
            }
        });
        return future;
    }

    private static PartnerModData getFallbackData() throws IOException {
        if (Files.exists(API_CACHE_FILE, new LinkOption[0])) {
            PartnerModData partnerModData;
            block15: {
                BufferedReader reader = Files.newBufferedReader(API_CACHE_FILE);
                try {
                    PartnerModData data = (PartnerModData)EssentialPartner.GSON.fromJson((Reader)reader, PartnerModData.class);
                    EssentialPartner.LOGGER.info("Loaded cached response");
                    partnerModData = data;
                    if (reader == null) break block15;
                }
                catch (Throwable data) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                data.addSuppressed(throwable);
                            }
                        }
                        throw data;
                    }
                    catch (Exception e) {
                        EssentialPartner.LOGGER.error("Failed to load cached response", (Throwable)e);
                    }
                }
                reader.close();
            }
            return partnerModData;
        }
        try (InputStream is = EssentialPartner.class.getResourceAsStream("assets/data.fallback.json");){
            Objects.requireNonNull(is, "Fallback data missing!");
            PartnerModData data = (PartnerModData)EssentialPartner.GSON.fromJson(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), PartnerModData.class);
            EssentialPartner.LOGGER.info("Loaded fallback data");
            PartnerModData partnerModData = data;
            return partnerModData;
        }
    }
}

