/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.inventory;

import com.hidoni.transmog.TransmogUtils;
import com.hidoni.transmog.registry.ModBlocks;
import com.hidoni.transmog.registry.ModItemTags;
import com.hidoni.transmog.registry.ModMenus;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class TransmogMenu
extends AbstractContainerMenu {
    public static final int ITEM_TO_TRANSMOG_SLOT = 0;
    public static final int APPEARANCE_ITEM_SLOT = 1;
    public static final int FUEL_ITEM_SLOT = 2;
    public static final int OUTPUT_SLOT = 3;
    private static final int INVENTORY_START = 4;
    private static final int INVENTORY_END = 40;
    private static final int HOTBAR_START = 31;
    public static final int CONTAINER_DATA_SLOT_COUNT = 1;
    private final Container inputContainer = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            TransmogMenu.this.m_6199_((Container)this);
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        public void m_6596_() {
            TransmogMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };
    private final ContainerLevelAccess access;
    private final ContainerData transmogBlockData;

    public TransmogMenu(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(1));
    }

    public TransmogMenu(int i, Inventory inventory, ContainerLevelAccess access, ContainerData transmogBlockData) {
        super((MenuType)ModMenus.TRANSMOG_MENU.get(), i);
        int j;
        TransmogMenu.m_38886_((ContainerData)transmogBlockData, (int)1);
        this.access = access;
        this.transmogBlockData = transmogBlockData;
        this.m_38897_(new Slot(this.inputContainer, 0, 38, 41));
        this.m_38897_(new Slot(this.inputContainer, 1, 87, 41){

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.inputContainer, 2, 11, 17){

            public boolean m_5857_(@NotNull ItemStack itemStack) {
                return itemStack.m_204117_(ModItemTags.TRANSMOG_FUELS);
            }
        });
        this.m_38897_(new Slot((Container)this.resultContainer, 3, 145, 41){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                super.m_142406_(player, stack);
                if (TransmogMenu.this.hasFuel()) {
                    TransmogMenu.this.consumeFuel();
                }
                TransmogMenu.this.m_38853_(0).m_6201_(1);
                TransmogMenu.this.m_38946_();
            }
        });
        this.m_38884_(transmogBlockData);
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = this.m_38853_(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack item = slot.m_7993_();
        ItemStack returnStack = item.m_41777_();
        if (index < 4) {
            boolean isOutputSlot;
            boolean bl = isOutputSlot = index == 3;
            if (!this.m_38903_(item, 4, 40, isOutputSlot)) {
                return ItemStack.f_41583_;
            }
            if (isOutputSlot) {
                slot.m_40234_(item, returnStack);
            }
        } else {
            boolean move = true;
            if (item.m_204117_(ModItemTags.TRANSMOG_FUELS)) {
                move = this.m_38903_(item, 2, 3, false);
            }
            if (move && !this.m_38903_(item, 0, 3, false) && (index < 31 ? !this.m_38903_(item, 31, 40, false) : !this.m_38903_(item, 4, 31, false))) {
                return ItemStack.f_41583_;
            }
        }
        if (item.m_41619_()) {
            slot.m_269060_(ItemStack.f_41583_);
        }
        slot.m_6654_();
        if (item.m_41613_() == returnStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, item);
        this.m_38946_();
        return returnStack;
    }

    public void m_6199_(@NotNull Container container) {
        if (this.getFuel() == 0 && this.m_38853_(2).m_6657_()) {
            this.refuel();
            this.m_38853_(2).m_6201_(1);
        }
        if (this.canTransmogItem()) {
            this.setupResultSlot();
        } else {
            this.resultContainer.m_8016_(3);
        }
    }

    private boolean canTransmogItem() {
        return this.m_38853_(0).m_6657_() && this.hasFuel();
    }

    private void setupResultSlot() {
        this.access.m_39292_((level, pos) -> {
            if (!this.m_38853_(1).m_6657_()) {
                if (TransmogUtils.isItemStackTransmogged(this.m_38853_(0).m_7993_())) {
                    this.outputRemovedTransmog();
                } else {
                    this.resultContainer.m_8016_(3);
                }
            } else {
                this.outputTransmoggedItem();
            }
        });
    }

    private void outputRemovedTransmog() {
        ItemStack item = this.m_38853_(0).m_7993_().m_255036_(1);
        item.m_41749_("transmog:transmogItem");
        this.resultContainer.m_6836_(3, item);
        this.m_38946_();
    }

    private void outputTransmoggedItem() {
        ItemStack originalItemToTransmog = this.m_38853_(0).m_7993_().m_255036_(1);
        ItemStack itemToTransmog = this.createTransmoggedItem(originalItemToTransmog);
        if (ItemStack.m_41728_((ItemStack)itemToTransmog, (ItemStack)originalItemToTransmog)) {
            this.resultContainer.m_8016_(3);
        } else {
            this.resultContainer.m_6836_(3, itemToTransmog);
            this.m_38946_();
        }
    }

    @NotNull
    public ItemStack createTransmoggedItem(ItemStack itemToTransmog) {
        ItemStack itemCopy = itemToTransmog.m_255036_(1);
        ItemStack appearanceItem = TransmogUtils.getAppearanceItemStack(this.m_38853_(1).m_7993_(), true).m_255036_(1);
        TransmogUtils.transmogAppearanceOntoItemStack(appearanceItem, itemCopy);
        return itemCopy;
    }

    private void refuel() {
        this.transmogBlockData.m_8050_(0, 3);
    }

    private void consumeFuel() {
        this.transmogBlockData.m_8050_(0, this.getFuel() - 1);
    }

    public int getFuel() {
        return this.transmogBlockData.m_6413_(0);
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    public boolean m_6875_(@NotNull Player player) {
        return TransmogMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.TRANSMOGRIFICATION_TABLE.get()));
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(3);
        this.access.m_39292_(($$1, $$2) -> this.m_150411_(player, this.inputContainer));
    }
}

