/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class BasicDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    protected EditBox dialogBox;
    protected Button saveButton = null;
    protected int numberOfTextLines = 1;
    private String dialogValue = "";
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public BasicDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicDialogButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)new CancelButton(this.rightPos - 130, this.bottomPos - 40, "cancel", onPress -> this.showMainScreen()));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)TextComponent.getTranslatedConfigText("dialog_placeholder"), this.imageWidth - 20);
        this.numberOfTextLines = this.textComponents.size();
        this.dialogValue = this.hasDialog() && this.getDialogDataSet().getType() == DialogType.BASIC ? this.getDialogDataSet().getDefaultDialog().getText() : "";
        this.dialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.topPos + 60, 300);
        this.dialogBox.m_94199_(512);
        this.dialogBox.m_94144_(this.dialogValue);
        this.m_142416_((GuiEventListener)this.dialogBox);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.contentLeftPos + 26, this.bottomPos - 40, "save", onPress -> {
            DialogDataSet dialogDataSet = DialogUtils.getBasicDialog(this.dialogBox.m_94155_());
            NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
            this.dialogValue = this.dialogBox.m_94155_();
        }));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        Text.drawConfigString(guiGraphics, this.f_96547_, "dialog_text", this.contentLeftPos, this.topPos + 50);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.leftPos + 15, this.topPos + 100 + line * (9 + 2));
            }
        }
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = !this.dialogBox.m_94155_().equals(this.dialogValue);
        }
    }
}

