/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import de.markusbordihn.easynpc.config.Config;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RenderEntityTypeSupportConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "render_entity_type_support.cfg";
    public static final String CONFIG_FILE_HEADER = "Render Entity Type Support Configuration\n\n Please note that this configuration file only includes confirmed entity types.\n If an entity type is not listed here, it doesn't mean it's automatically supported or unsupported!\n";
    private static final Set<String> knownUnsupportedEntityTypes = new HashSet<String>(List.of("minecraft:area_effect_cloud", "minecraft:armor_stand", "minecraft:arrow", "minecraft:bat", "minecraft:boat", "minecraft:chest_minecart", "minecraft:command_block_minecart", "minecraft:dragon_fireball", "minecraft:egg", "minecraft:end_crystal", "minecraft:ender_pearl", "minecraft:ender_dragon", "minecraft:evoker_fangs", "minecraft:experience_bottle", "minecraft:experience_orb", "minecraft:eye_of_ender", "minecraft:falling_block", "minecraft:fireball", "minecraft:firework_rocket", "minecraft:fishing_bobber", "minecraft:furnace_minecart", "minecraft:ghast", "minecraft:glow_item_frame", "minecraft:hopper_minecart", "minecraft:item", "minecraft:item_frame", "minecraft:leash_knot", "minecraft:lightning_bolt", "minecraft:llama_spit", "minecraft:marker", "minecraft:magma_cube", "minecraft:minecart", "minecraft:phantom", "minecraft:player", "minecraft:painting", "minecraft:potion", "minecraft:shulker_bullet", "minecraft:small_fireball", "minecraft:snowball", "minecraft:spawner_minecart", "minecraft:spectral_arrow", "minecraft:slime", "minecraft:text_display", "minecraft:tnt", "minecraft:tnt_minecart", "minecraft:trident", "minecraft:wither_skull", "ad_astra:ice_spit", "ad_astra:lander", "ad_astra:space_painting", "ad_astra:tier_1_rocket", "ad_astra:tier_1_rover", "ad_astra:tier_2_rocket", "ad_astra:tier_3_rocket", "ad_astra:tier_4_rocket", "ae2:tiny_tnt_primed", "aquamirae:pillagers_patrol", "armourers_workshop:mannequin", "botania:babylon_weapon", "botania:corporea_spark", "botania:doppleganger", "botania:ender_air", "botania:ender_air_bottle", "botania:falling_star", "botania:flame_ring", "botania:magic_landmine", "botania:magic_missile", "botania:mana_burst", "botania:mana_storm", "botania:pixie", "botania:player_mover", "botania:pool_minecart", "botania:spark", "botania:thorn_chakram", "botania:thrown_item", "create:carriage_contraption", "create:contraption", "create:crafting_blueprint", "create:gantry_contraption", "create:seat", "create:stationary_contraption", "create:super_glue", "dannys_expansion:mundane_slime", "dummmmmmy:target_dummy", "farmersdelight:rotten_tomato", "friendsandfoes:ice_chunk", "friendsandfoes:player_illusion", "frostiful:freezing_wind", "frostiful:frost_spell", "frostiful:packed_snowball", "frostiful:thrown_icicle", "graveyard:ghouling", "graveyard:skull", "handcrafted:fancy_painting", "handcrafted:seat", "lootr:lootr_minecart", "majruszsdifficulty:cursed_armor", "moretotems:summoned_bee", "moretotems:summoned_zombie", "orcz:decaystrikecustom", "orcz:wither_strikeringcustom", "simple_mobs:ground_spike", "simple_mobs:dragon_smoke", "simple_mobs:elemental_chain", "simple_mobs:lightning_spear", "simple_mobs:projecttest", "simple_mobs:rumble", "simple_mobs:staff_interact", "simple_mobs:staff_usage", "smallships:brigg", "smallships:cog", "smallships:galley", "swampier_swamps:swamp_gas", "techreborn:nuke", "terraform:boat", "the_bumblezone:bee_stinger", "the_bumblezone:cosmic_crystal_entity", "the_bumblezone:dirt_pellet", "the_bumblezone:electric_ring_entity", "the_bumblezone:honey_crystal_shard", "the_bumblezone:pollen_puff", "the_bumblezone:purple_spike_entity", "the_bumblezone:sentry_watcher", "the_bumblezone:thrown_stinger_spear", "twigs:pebble"));
    private static final Set<String> knownSupportedEntityTypes = new HashSet<String>(List.of("minecraft:axolotl", "minecraft:bee", "minecraft:blaze", "minecraft:cat", "minecraft:cave_spider", "minecraft:chicken", "minecraft:cod", "minecraft:cow", "minecraft:creeper", "minecraft:dolphin", "minecraft:donkey", "minecraft:drowned", "minecraft:elder_guardian", "minecraft:enderman", "minecraft:endermite", "minecraft:evoker", "minecraft:fox", "minecraft:giant", "minecraft:glow_squid", "minecraft:goat", "minecraft:guardian", "minecraft:hoglin", "minecraft:horse", "minecraft:husk", "minecraft:illusioner", "minecraft:iron_golem", "minecraft:llama", "minecraft:mooshroom", "minecraft:mule", "minecraft:ocelot", "minecraft:panda", "minecraft:parrot", "minecraft:pig", "minecraft:piglin", "minecraft:piglin_brute", "minecraft:pillager", "minecraft:polar_bear", "minecraft:pufferfish", "minecraft:rabbit", "minecraft:ravager", "minecraft:salmon", "minecraft:sheep", "minecraft:shulker", "minecraft:silverfish", "minecraft:skeleton", "minecraft:skeleton_horse", "minecraft:snow_golem", "minecraft:spider", "minecraft:squid", "minecraft:stray", "minecraft:strider", "minecraft:trader_llama", "minecraft:tropical_fish", "minecraft:turtle", "minecraft:vex", "minecraft:villager", "minecraft:vindicator", "minecraft:wandering_trader", "minecraft:witch", "minecraft:wither", "minecraft:wither_skeleton", "minecraft:wolf", "minecraft:zoglin", "minecraft:zombie", "minecraft:zombie_horse", "minecraft:zombie_villager", "minecraft:zombified_piglin"));
    private static final Set<String> supportedEntityTypes = new HashSet<String>();
    private static final Set<String> unsupportedEntityTypes = new HashSet<String>();

    public static void registerConfig() {
        RenderEntityTypeSupportConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        RenderEntityTypeSupportConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = RenderEntityTypeSupportConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = RenderEntityTypeSupportConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (String entityType : knownUnsupportedEntityTypes) {
            if (RenderEntityTypeSupportConfig.parseConfigValue(properties, entityType, false)) {
                RenderEntityTypeSupportConfig.addSupportedEntityType(entityType);
                continue;
            }
            RenderEntityTypeSupportConfig.addUnsupportedEntityType(entityType);
        }
        for (String entityType : knownSupportedEntityTypes) {
            if (RenderEntityTypeSupportConfig.parseConfigValue(properties, entityType, true)) {
                RenderEntityTypeSupportConfig.addSupportedEntityType(entityType);
                continue;
            }
            RenderEntityTypeSupportConfig.addUnsupportedEntityType(entityType);
        }
        for (String entityType : properties.stringPropertyNames()) {
            if (knownSupportedEntityTypes.contains(entityType) || knownUnsupportedEntityTypes.contains(entityType)) continue;
            if (entityType == null || !entityType.contains(":")) {
                log.error("Remove invalid entity type {} from {}.", (Object)entityType, (Object)CONFIG_FILE_NAME);
                properties.remove(entityType);
                continue;
            }
            if (RenderEntityTypeSupportConfig.parseConfigValue(properties, entityType, false)) {
                RenderEntityTypeSupportConfig.addSupportedEntityType(entityType);
                continue;
            }
            RenderEntityTypeSupportConfig.addUnsupportedEntityType(entityType);
        }
        RenderEntityTypeSupportConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static void addUnsupportedEntityType(String entityType) {
        unsupportedEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
    }

    public static void addSupportedEntityType(String entityType) {
        supportedEntityTypes.add(entityType);
        unsupportedEntityTypes.remove(entityType);
    }

    public static boolean isSupportedEntityType(String entityType) {
        return supportedEntityTypes.contains(entityType);
    }

    public static boolean isUnsupportedEntityType(String entityType) {
        return unsupportedEntityTypes.contains(entityType);
    }
}

