/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;

public interface AttributeData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static void registerSyncedAttributeData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.ENTITY_ATTRIBUTES, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ENTITY_ATTRIBUTES));
    }

    default public void setBaseAttribute(Attribute attribute, double value) {
        if (attribute == null || this.getLivingEntity().m_21051_(attribute) == null) {
            return;
        }
        this.getLivingEntity().m_21051_(attribute).m_22100_(value);
    }

    default public double getBaseAttribute(Attribute attribute) {
        if (attribute == null || this.getLivingEntity().m_21051_(attribute) == null) {
            return 0.0;
        }
        return this.getLivingEntity().m_21051_(attribute).m_22115_();
    }

    default public EntityAttributes getEntityAttributes() {
        return (EntityAttributes)this.getSynchedEntityData(SynchedDataIndex.ENTITY_ATTRIBUTES);
    }

    default public void setEntityAttributes(EntityAttributes entityAttributes) {
        this.setSynchedEntityData(SynchedDataIndex.ENTITY_ATTRIBUTES, entityAttributes);
    }

    default public void refreshEntityAttributes() {
        EntityAttributes entityAttributes = this.getEntityAttributes();
        if (entityAttributes != null) {
            this.setEntityAttributes(new EntityAttributes());
            this.setEntityAttributes(entityAttributes);
        }
    }

    default public boolean getAttributeSilent() {
        return this.getEntity().m_20067_();
    }

    default public void setAttributeSilent(boolean silent) {
        this.getEntity().m_20225_(silent);
    }

    default public void defineSynchedAttributeData() {
        this.defineSynchedEntityData(SynchedDataIndex.ENTITY_ATTRIBUTES, new EntityAttributes());
    }

    default public void addAdditionalAttributeData(CompoundTag compoundTag) {
        EntityAttributes entityAttributes = this.getEntityAttributes();
        if (entityAttributes != null) {
            entityAttributes.save(compoundTag);
        }
    }

    default public void readAdditionalAttributeData(CompoundTag compoundTag) {
        this.setEntityAttributes(new EntityAttributes(compoundTag));
    }
}

