/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.client;

import de.markusbordihn.easynpc.data.dialog.DialogDataManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record SyncDataMessage(UUID uuid, DialogDataSet dialogDataSet) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "sync_data");

    public static SyncDataMessage create(FriendlyByteBuf buffer) {
        return new SyncDataMessage(buffer.m_130259_(), new DialogDataSet(buffer.m_130260_()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130079_(this.dialogDataSet.createTag());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)this.uuid, (Object)this);
            return;
        }
        if (this.dialogDataSet != null) {
            log.debug("Syncing dialog data for {} with {}", (Object)this.uuid, (Object)this.dialogDataSet);
            DialogDataManager.addDialogDataSet(this.uuid, this.dialogDataSet);
        }
    }
}

