/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record SaveDialogMessage(UUID uuid, UUID dialogId, DialogDataEntry dialogDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "save_dialog");

    public static SaveDialogMessage create(FriendlyByteBuf buffer) {
        return new SaveDialogMessage(buffer.m_130259_(), buffer.m_130259_(), new DialogDataEntry(buffer.m_130260_()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130077_(this.dialogId);
        buffer.m_130079_(this.dialogDataEntry.createTag());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogDataEntry == null) {
            log.error("Invalid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Saving dialog data {} for dialog {} for {} from {}", (Object)this.dialogDataEntry, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        dialogData.setDialog(this.dialogId, this.dialogDataEntry);
    }
}

