/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import org.jetbrains.annotations.NotNull;

public class Nest
extends Block {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty COUNT = IntegerProperty.m_61631_((String)"count", (int)0, (int)5);
    public static final EnumProperty<Egg> EGG = EnumProperty.m_61587_((String)"egg", Egg.class);
    public static final BooleanProperty IS_DECORATIVE = BooleanProperty.m_61465_((String)"is_decorative");

    public Nest(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_(EGG, (Comparable)((Object)Egg.NONE))).m_61124_((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_(EGG, (Comparable)((Object)Egg.NONE))).m_61124_((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ((Egg)((Object)state.m_61143_(Nest.EGG))).shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{COUNT, HATCH, EGG, IS_DECORATIVE});
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_DECORATIVE);
    }

    public int getHatchLevel(BlockState state) {
        return (Integer)state.m_61143_((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState state) {
        return this.getHatchLevel(state) == 2;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Egg egg = (Egg)((Object)state.m_61143_(EGG));
        if (egg == Egg.NONE) {
            Egg newEgg = Egg.getByItem(itemStack.m_41720_());
            if (newEgg != Egg.NONE) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.setEgg(state, level, pos, newEgg);
                level.m_247517_(player, pos, SoundEvents.f_12065_, SoundSource.BLOCKS);
                if (level.f_46443_) {
                    ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_276512_, (IntProvider)UniformInt.m_146622_((int)3, (int)6));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else {
            if (itemStack.m_150930_(egg.item.get()) && (Integer)state.m_61143_((Property)COUNT) < egg.maxCount && (Integer)state.m_61143_((Property)HATCH) == 0) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)COUNT) + 1)), 2);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (itemStack.m_150930_((Item)WabItems.CHISEL.get()) && !this.isDecorative(state)) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41622_(1, (LivingEntity)player, e -> {});
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(true)), 2);
                level.m_247517_(player, pos, SoundEvents.f_12064_, SoundSource.BLOCKS);
                if (level.f_46443_) {
                    ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_175828_, (IntProvider)UniformInt.m_146622_((int)3, (int)6));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (!this.isDecorative(state)) {
            if (!this.isReadyToHatch(state)) {
                level.m_5594_((Player)null, pos, SoundEvents.f_276434_, SoundSource.BLOCKS, 0.7f, 0.9f + source.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
            } else {
                level.m_5594_((Player)null, pos, SoundEvents.f_276489_, SoundSource.BLOCKS, 0.7f, 0.9f + source.m_188501_() * 0.2f);
                this.setEgg(state, (Level)level, pos, Egg.NONE);
                EntityType<? extends LivingEntity> entityType = ((Egg)((Object)state.m_61143_(Nest.EGG))).entity.get();
                if (entityType != null) {
                    for (int i = 0; i < (Integer)state.m_61143_((Property)COUNT); ++i) {
                        LivingEntity entity = (LivingEntity)entityType.m_20615_((Level)level);
                        if (entity == null) continue;
                        Vec3 vec3 = pos.m_252807_();
                        if (entity instanceof AgeableMob) {
                            AgeableMob mob = (AgeableMob)entity;
                            mob.m_6863_(true);
                        }
                        entity.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
                        level.m_7967_((Entity)entity);
                    }
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            this.setHatchTick((Egg)((Object)newState.m_61143_(EGG)), level, pos);
        } else {
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, ((Egg)((Object)state.m_61143_(EGG))).getItemStack((Integer)state.m_61143_((Property)COUNT)));
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void setEgg(BlockState state, Level level, BlockPos pos, Egg egg) {
        if (egg == Egg.NONE) {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_(EGG, (Comparable)((Object)egg))).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)), 3);
        } else {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_(EGG, (Comparable)((Object)egg))).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    protected void setHatchTick(Egg egg, Level level, BlockPos pos) {
        if (egg.hatchTicks > 0) {
            level.m_186460_(pos, (Block)this, egg.hatchTicks + level.f_46441_.m_188503_(300));
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    public static enum Egg implements StringRepresentable
    {
        NONE("none", () -> Items.f_41852_, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), 0, 0, () -> null),
        CHICKEN("chicken", () -> Items.f_42521_, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), 5, 0, () -> EntityType.f_20555_),
        TURTLE("turtle", () -> Items.f_42279_, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), 4, 12000, () -> EntityType.f_20490_),
        SNIFFER("sniffer", () -> Items.f_276468_, Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0), 1, 2200, () -> EntityType.f_271264_),
        EATER("eater", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.EATER_EGG.get()))).m_5456_(), BeastEggBlock.EATER_EGG_SHAPE, 1, 2200, () -> WabEntities.EATER.get()),
        WALKER("walker", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.WALKER_EGG.get()))).m_5456_(), BeastEggBlock.WALKER_EGG_SHAPE, 1, 2200, () -> WabEntities.WALKER.get()),
        CRUSHER("crusher", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.CRUSHER_EGG.get()))).m_5456_(), BeastEggBlock.CRUSHER_EGG_SHAPE, 1, 2200, () -> WabEntities.CRUSHER.get()),
        GLIDER("glider", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.GLIDER_EGG.get()))).m_5456_(), BeastEggBlock.GLIDER_EGG_SHAPE, 1, 2200, () -> WabEntities.GLIDER.get()),
        SOARER("soarer", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.SOARER_EGG.get()))).m_5456_(), BeastEggBlock.SOARER_EGG_SHAPE, 1, 2200, () -> WabEntities.SOARER.get()),
        SURFER("surfer", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.SURFER_EGG.get()))).m_5456_(), BeastEggBlock.SURFER_EGG_SHAPE, 1, 2200, () -> WabEntities.SURFER.get());

        public final VoxelShape NEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
        private final String name;
        public final Supplier<Item> item;
        public final VoxelShape shape;
        public final int maxCount;
        public final int hatchTicks;
        public final Supplier<EntityType<? extends LivingEntity>> entity;

        private Egg(String name, Supplier<Item> item, VoxelShape shape, int maxCount, int hatchTicks, Supplier<EntityType<? extends LivingEntity>> entity) {
            this.name = name;
            this.item = item;
            this.shape = Shapes.m_83110_((VoxelShape)this.NEST_SHAPE, (VoxelShape)shape);
            this.maxCount = maxCount;
            this.hatchTicks = hatchTicks;
            this.entity = entity;
        }

        public static Egg getByItem(Item item) {
            for (Egg egg : Egg.values()) {
                if (egg.item.get() != item) continue;
                return egg;
            }
            return NONE;
        }

        public ItemStack getItemStack(int count) {
            return new ItemStack((ItemLike)this.item.get(), count);
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

