/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.capability.provider.QuickSandProvider;
import net.wanmine.wab.init.data.WabDamageType;
import net.wanmine.wab.init.data.WabTriggers;

public class QuickSand
extends PowderSnowBlock {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    public final Supplier<SolidBucketItem> bucket;
    public final int color;

    public QuickSand(Supplier<SolidBucketItem> bucket, int color, BlockBehaviour.Properties properties) {
        super(properties);
        this.bucket = bucket;
        this.color = color;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) {
            entity.m_7601_(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        }
        if (BlockPos.m_274446_((Position)entity.m_146892_()).equals((Object)pos)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                WabTriggers.QUICK_SAND_FALL.m_222618_(player);
            }
            entity.getCapability(QuickSandProvider.QUICKSAND).ifPresent(cap -> {
                if (cap.getLastTickInQuicksand() != entity.m_9236_().m_46467_()) {
                    cap.addTickInQuicksand(entity.m_9236_().m_46467_());
                    entity.m_20301_(Math.max(0, entity.m_20146_() - 6));
                    if (entity.m_20146_() <= 0) {
                        entity.m_6469_(WabDamageType.damageSource((LevelReader)level, WabDamageType.QUICK_SAND), 1.5f);
                    }
                }
            });
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)context).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            if (entity instanceof FallingBlockEntity) {
                return super.m_5939_(state, getter, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        levelAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        return new ItemStack((ItemLike)this.bucket.get());
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_12331_);
    }
}

