/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.entity.PartEntity;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.goals.fly.FlyFollowOwnerGoal;
import net.wanmine.wab.entity.goals.fly.FlyPanicGoal;
import net.wanmine.wab.entity.goals.fly.RandomFlyGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.WabEntityPartHead;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.PacketHandler;
import net.wanmine.wab.network.client.ClientGliderPartyingPacket;
import net.wanmine.wab.network.server.ServerGliderPartyingPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Glider
extends TamableAnimal
implements FlyingAnimal,
GeoEntity {
    public static final String ID = "glider";
    public static final String SPAWN_EGG_ID = "glider_spawn_egg";
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Glider.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean partying;
    private int tickLeft = 0;
    private int flapTick = -1;
    private final WabEntityPart<Glider>[] subEntities;
    private final WabEntityPartHead<Glider> head = new WabEntityPartHead<Glider>(this, 0.6f, 1.1f, 0.8f, 0.3f);

    public Glider(EntityType<Glider> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.head};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.GLIDER_HEALTH.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.GLIDER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("partying", this.partying);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.partying = pCompound.m_128471_("partying");
    }

    public static boolean canSpawn(EntityType<? extends Glider> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Glider.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FlyPanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FlyFollowOwnerGoal(this, 1.0, 16.0f, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42529_}), false));
        this.f_21345_.m_25352_(7, (Goal)new RandomFlyGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level world) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        return flyingpathnavigation;
    }

    public void m_6457_(ServerPlayer pServerPlayer) {
        PacketHandler.sendToPlayer(new ClientGliderPartyingPacket(this.m_19879_(), this.partying), pServerPlayer);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.GLIDER.get()).m_20615_((Level)level);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.GLIDER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42527_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Glider.state(this), Glider.baby(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Glider> state(Glider glider) {
        return new AnimationController((GeoAnimatable)glider, "state", 1, state -> {
            if (glider.tickLeft <= 0) {
                if (state.isMoving() && glider.m_29443_()) {
                    glider.setState(State.FLY);
                } else if (glider.isPartying()) {
                    glider.setState(State.DANCE);
                } else if (glider.m_21825_()) {
                    glider.setState(State.SIT);
                } else {
                    glider.setState(State.IDLE);
                }
            }
            return state.setAndContinue(glider.getState().getAnimation());
        });
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if (state == State.FLY && this.getState().isIdle()) {
            state = State.START_FLYING;
        } else if (state.isIdle() && this.getState() == State.FLY) {
            state = State.STOP_FLYING;
        }
        if (state == State.FLY && this.getState() != State.FLY) {
            this.flapTick = 60;
        } else if (this.getState() != State.FLY) {
            this.flapTick = -1;
        }
        this.tickLeft = state.getDuration();
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.getState() == State.START_FLYING && this.tickLeft == State.START_FLYING.getDuration() - 15) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.GLIDER_FLAP_START.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.STOP_FLYING && this.tickLeft == State.STOP_FLYING.getDuration()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.GLIDER_LANDING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
            if (this.flapTick >= 0) {
                if (this.flapTick == 60 || this.flapTick == 30) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.GLIDER_FLAP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
                --this.flapTick;
                if (this.flapTick == 0) {
                    this.flapTick = 60;
                }
            }
            if (this.tickLeft > 0) {
                --this.tickLeft;
            }
        } else if (this.isPartying() && this.m_9236_().m_46467_() % 60L == 0L && this.f_19796_.m_188503_(40) == 0) {
            ItemStack itemstack = new ItemStack((ItemLike)WabItems.GLIDER_FEATHER.get());
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, itemstack);
            itementity.m_32060_();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12640_, SoundSource.NEUTRAL, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (WabEntityPart<Glider> part : this.subEntities) {
            part.update();
        }
    }

    public void m_6818_(BlockPos pPos, boolean pIsPartying) {
        this.partying = pIsPartying;
        PacketHandler.sendToServer(new ServerGliderPartyingPacket(this.m_19879_(), pIsPartying));
    }

    public boolean isPartying() {
        return this.partying;
    }

    public void setPartying(boolean partying) {
        this.partying = partying;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.m_21824_() && itemstack.m_150930_(Items.f_42529_)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(pPlayer);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5634_(2.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_146740_(Glider.m_216967_((int)(-this.m_146764_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_6162_() && !this.m_27593_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_21830_((LivingEntity)pPlayer)) {
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public boolean m_29443_() {
        return !this.m_20096_() || this.m_20184_().f_82480_ != 0.0;
    }

    public boolean m_6147_() {
        return false;
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)WabSounds.GLIDER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.GLIDER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_29443_() ? null : (SoundEvent)WabSounds.GLIDER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle_ground"), true),
        SIT(RawAnimation.begin().thenPlay("misc.sit"), true),
        WALK(RawAnimation.begin().thenPlay("move.walk"), false),
        START_FLYING(RawAnimation.begin().thenPlay("move.start_flying"), false, 25),
        FLY(RawAnimation.begin().thenPlay("move.fly"), false),
        STOP_FLYING(RawAnimation.begin().thenPlay("move.landing"), false, 30),
        DANCE(RawAnimation.begin().thenPlay("misc.dance"), true);

        private final RawAnimation animation;
        private final boolean isIdle;
        private final int duration;

        private State(RawAnimation animation, boolean isIdle) {
            this.animation = animation;
            this.isIdle = isIdle;
            this.duration = 0;
        }

        private State(RawAnimation animation, boolean isIdle, int duration) {
            this.animation = animation;
            this.isIdle = isIdle;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

