/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.wanmine.wab.init.gen.data.loot.WabBlockLootGenerator;
import net.wanmine.wab.init.gen.data.loot.WabEntityLootGenerator;

public class WabLootTableGenerator {
    public static LootTableProvider create(PackOutput output) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(WabBlockLootGenerator::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(WabEntityLootGenerator::new, LootContextParamSets.f_81415_)));
    }

    public static class PostProcessor
    implements DataProvider {
        private final PackOutput output;
        private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

        public PostProcessor(PackOutput output) {
            this.output = output;
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            Path lootTablesFolder = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve("wan_ancient_beasts").resolve("loot_tables");
            ArrayList list = new ArrayList();
            if (Files.exists(lootTablesFolder, new LinkOption[0])) {
                try {
                    Files.walk(lootTablesFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                        try (BufferedReader reader = Files.newBufferedReader(path);){
                            JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                            if (json.has("pools") && json.get("pools").isJsonArray()) {
                                JsonArray pools = json.getAsJsonArray("pools");
                                for (int i = 0; i < pools.size(); ++i) {
                                    JsonObject pool = pools.get(i).getAsJsonObject();
                                    if (pool.has("name")) continue;
                                    pool.addProperty("name", "main");
                                }
                                list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path));
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        }

        public String m_6055_() {
            return "LootTable Post Processor";
        }
    }
}

