/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity;

import com.eeeab.eeeabsmobs.client.sound.BossMusicPlayer;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.EMBossInfoServer;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.eeeab.eeeabsmobs.sever.util.damage.DamageAdaptation;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EEEABMobEntity
extends PathfinderMob {
    private final EMBossInfoServer bossInfo = new EMBossInfoServer(this);
    private final DamageAdaptation intervalProtector;
    private DamageSource killDataCause;
    public DamageSource lastDamageSource;
    public Player killDataAttackingPlayer;
    public float targetDistance = -1.0f;
    public float targetAngle = -1.0f;
    public boolean active;
    public int frame;
    public boolean dropAfterDeathAnim = true;
    public int killDataRecentlyHit;
    public LivingEntity blockEntity = null;
    private static final byte MAKE_POOF_ID = 60;
    private static final byte PLAY_BOSS_MUSIC_ID = 77;
    private static final byte STOP_BOSS_MUSIC_ID = 78;
    private static final UUID HEALTH_UUID = UUID.fromString("cca33d36-6842-43d8-b615-0cad4460a18a");
    private static final UUID ATTACK_UUID = UUID.fromString("e1b02986-1699-4120-a687-40419a294482");

    public EEEABMobEntity(EntityType<? extends EEEABMobEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = this.getEntityReward().getXp();
        this.intervalProtector = new DamageAdaptation(50, 9, 0.35f, 0.9995f, true).setAdaptBypassesDamage(true);
        EMConfigHandler.AttributeConfig config = this.getAttributeConfig();
        if (config != null) {
            AttributeInstance attackAttribute;
            AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
            if (healthAttribute != null) {
                double finalValue = healthAttribute.m_22115_() * (Double)config.healthMultiplier.get() - healthAttribute.m_22115_();
                healthAttribute.m_22118_(new AttributeModifier(HEALTH_UUID, "Reset health by config", finalValue, AttributeModifier.Operation.ADDITION));
                this.m_21153_(this.m_21233_());
            }
            if ((attackAttribute = this.m_21051_(Attributes.f_22281_)) != null) {
                double finalValue = attackAttribute.m_22115_() * (Double)config.attackMultiplier.get() - attackAttribute.m_22115_();
                attackAttribute.m_22118_(new AttributeModifier(ATTACK_UUID, "Reset attack damage by config", finalValue, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource);
    }

    public boolean m_6128_() {
        return super.m_6128_();
    }

    public boolean m_6051_() {
        return super.m_6051_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return super.m_142535_(fallDistance, multiplier, damageSource);
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return super.m_147207_(effectInstance, entity);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.frame;
        if (this.m_5448_() != null) {
            this.targetDistance = this.m_20270_((Entity)this.m_5448_()) - this.m_5448_().m_20205_() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.m_5448_());
        }
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            if (!this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)78);
            } else if (!this.canHandOffMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)77);
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ % 4 == 0) {
            this.bossInfo.update();
        }
    }

    public void m_21153_(float health) {
        if (!this.m_9236_().f_46443_ && health < this.m_21223_()) {
            health = this.getNewHealthByCap(health, this.getDamageCap());
            this.lastDamageSource = null;
        }
        super.m_21153_(health);
    }

    protected float getNewHealthByCap(float health, EMConfigHandler.DamageCapConfig config) {
        if (config != null) {
            float oldDamage;
            float newDamage = oldDamage = this.m_21223_() - health;
            float damageCap = ((Double)config.damageCap.get()).floatValue();
            if (this.lastDamageSource == null) {
                newDamage = ModEntityUtils.actualDamageIsCalculatedBasedOnArmor(Math.min(oldDamage, damageCap), this.m_21230_(), (float)this.m_21133_(Attributes.f_22285_), 1.0f);
            } else if (!this.lastDamageSource.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
                newDamage = Math.min(oldDamage, damageCap);
            }
            if (this.intervalProtect()) {
                newDamage = this.intervalProtector.damageAfterAdaptingOnce((LivingEntity)this, this.lastDamageSource, newDamage);
            }
            health = this.m_21223_() - newDamage;
        }
        return health;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            this.lastDamageSource = source;
        }
        return super.m_6469_(source, amount);
    }

    protected final void m_6153_() {
        this.dying();
        ++this.f_20919_;
        int deathDuration = this.getDeathDuration();
        if (this.f_20919_ >= deathDuration && !this.m_9236_().m_5776_()) {
            this.f_20888_ = this.killDataAttackingPlayer;
            this.f_20889_ = this.killDataRecentlyHit;
            if (this.dropAfterDeathAnim && this.killDataCause != null) {
                this.m_6668_(this.killDataCause);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void dying() {
    }

    protected int getDeathDuration() {
        return 20;
    }

    protected void m_6668_(DamageSource source) {
        if (!this.dropAfterDeathAnim || this.f_20919_ > 0) {
            super.m_6668_(source);
        }
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_20890_) {
            this.killDataCause = source;
            this.killDataRecentlyHit = this.f_20889_;
            this.killDataAttackingPlayer = this.f_20888_;
        }
        super.m_6667_(source);
        if (!this.m_213877_()) {
            this.bossInfo.update();
        }
    }

    public boolean m_7327_(Entity entity) {
        return this.doHurtTarget(entity, 1.0f, 1.0f);
    }

    public boolean doHurtTarget(Entity entity, float damageMultiplier, float knockBackMultiplier) {
        return this.doHurtTarget(entity, damageMultiplier, knockBackMultiplier, false);
    }

    public boolean doHurtTarget(Entity entity, float damageMultiplier, float knockBackMultiplier, boolean canDisableShield) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_) * damageMultiplier;
        float f1 = (float)this.m_21133_(Attributes.f_22282_) * knockBackMultiplier;
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (canDisableShield) {
                    this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return flag;
    }

    private void m_21424_(Player player, ItemStack mobItemStack, ItemStack playerItemStack) {
        if (!mobItemStack.m_41619_() && !playerItemStack.m_41619_() && mobItemStack.m_41720_() instanceof AxeItem && playerItemStack.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 77) {
            BossMusicPlayer.playBossMusic(this, this.getBossMusic());
        } else if (id == 78) {
            BossMusicPlayer.stopBossMusic(this);
        } else if (id == 60) {
            this.m_147246_();
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_147246_() {
        for (int i = 0; i < 20; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void m_8099_() {
        this.registerCustomGoals();
    }

    protected void registerCustomGoals() {
    }

    protected boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_5803_() || this.m_20365_(entityIn) || entityIn.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.m_20160_() && this.canBePushedByEntity(entityIn)) {
                this.m_5997_(-d0, 0.0, -d1);
            }
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public List<LivingEntity> getNearByLivingEntities(double range) {
        return this.getNearByEntities(LivingEntity.class, range, range, range, range);
    }

    public List<LivingEntity> getNearByLivingEntities(double rangeX, double height, double rangeZ, double radius) {
        return this.getNearByEntities(LivingEntity.class, rangeX, height, rangeZ, radius);
    }

    public <T extends Entity> List<T> getNearByEntities(Class<T> entityClass, double x, double y, double z, double radius) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(x, y, z), targetEntity -> targetEntity != this && (double)this.m_20270_((Entity)targetEntity) <= radius + (double)(targetEntity.m_20205_() / 2.0f) && targetEntity.m_20186_() <= this.m_20186_() + y);
    }

    public double getAngleBetweenEntities(Entity attacker, Entity target) {
        return Math.atan2(target.m_20189_() - attacker.m_20189_(), target.m_20185_() - attacker.m_20185_()) * 57.29577951308232 + 90.0;
    }

    protected void pushEntitiesAway(float X, float Y, float Z, float radius) {
        List<LivingEntity> entityList = this.getNearByLivingEntities(X, Y, Z, radius);
        for (Entity entity : entityList) {
            if (entity.f_19794_ || !entity.m_6087_()) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.m_20334_(-0.1 * Math.cos(angle), entity.m_20184_().f_82480_, -0.1 * Math.sin(angle));
        }
    }

    public Vec3 circlePosition(Vec3 targetVec3, float radius, float speed, boolean direction, int circleFrame, float offset) {
        double theta = (double)((direction ? 1 : -1) * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return targetVec3.m_82520_((double)radius * Math.cos(theta), 0.0, (double)radius * Math.sin(theta));
    }

    public void stun(@Nullable LivingEntity source, LivingEntity target, int duration, boolean force) {
        Player player;
        if (target.m_21254_() || this.m_7307_((Entity)target) || target instanceof Player && ((player = (Player)target).m_5833_() || player.m_7500_())) {
            return;
        }
        ModEntityUtils.addEffectStackingAmplifier((Entity)source, target, (MobEffect)EffectInit.VERTIGO_EFFECT.get(), duration, 1, false, false, true, true, force);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return null;
    }

    protected EMConfigHandler.DamageCapConfig getDamageCap() {
        return null;
    }

    protected boolean intervalProtect() {
        return false;
    }

    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_NORMAL;
    }

    protected boolean setDarkenScreen() {
        return false;
    }

    protected boolean showBossBloodBars() {
        return false;
    }

    protected BossEvent.BossBarColor bossBloodBarsColor() {
        return BossEvent.BossBarColor.PURPLE;
    }

    public float getHealthPercentage() {
        return this.m_21223_() / this.m_21233_() * 100.0f;
    }

    public SoundEvent getBossMusic() {
        return null;
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player;
    }

    protected boolean canHandOffMusic() {
        return false;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }
}

