/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.tombstone.enchantment.EnchantmentBlessing;
import ovh.corail.tombstone.enchantment.EnchantmentCurseOfBones;
import ovh.corail.tombstone.enchantment.EnchantmentDecrepitude;
import ovh.corail.tombstone.enchantment.EnchantmentFrostbite;
import ovh.corail.tombstone.enchantment.EnchantmentIncurableWounds;
import ovh.corail.tombstone.enchantment.EnchantmentMagicSiphon;
import ovh.corail.tombstone.enchantment.EnchantmentPlagueBringer;
import ovh.corail.tombstone.enchantment.EnchantmentRuthlessStrike;
import ovh.corail.tombstone.enchantment.EnchantmentSanctified;
import ovh.corail.tombstone.enchantment.EnchantmentSoulBound;
import ovh.corail.tombstone.enchantment.EnchantmentSpectralBite;
import ovh.corail.tombstone.enchantment.EnchantmentSpectralConjurer;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.Helper;

public final class ModEnchantments {
    public static Enchantment soulbound = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment magic_siphon = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment plague_bringer = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment curse_of_bones = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment blessing = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment frostbite = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment spectral_bite = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment spectral_conjurer = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment incurable_wounds = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment decrepitude = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment sanctified = (Enchantment)Helper.unsafeNullCast();
    public static Enchantment ruthless_strike = (Enchantment)Helper.unsafeNullCast();
    private static final Map<String, TombstoneEnchantment> ENCHANTMENTS = new HashMap<String, TombstoneEnchantment>();

    static void onRegister(RegisterEvent event) {
        soulbound = ModEnchantments.registerEnchantment(event, new EnchantmentSoulBound());
        magic_siphon = ModEnchantments.registerEnchantment(event, new EnchantmentMagicSiphon());
        plague_bringer = ModEnchantments.registerEnchantment(event, new EnchantmentPlagueBringer());
        curse_of_bones = ModEnchantments.registerEnchantment(event, new EnchantmentCurseOfBones());
        blessing = ModEnchantments.registerEnchantment(event, new EnchantmentBlessing());
        frostbite = ModEnchantments.registerEnchantment(event, new EnchantmentFrostbite());
        spectral_bite = ModEnchantments.registerEnchantment(event, new EnchantmentSpectralBite());
        spectral_conjurer = ModEnchantments.registerEnchantment(event, new EnchantmentSpectralConjurer());
        incurable_wounds = ModEnchantments.registerEnchantment(event, new EnchantmentIncurableWounds());
        decrepitude = ModEnchantments.registerEnchantment(event, new EnchantmentDecrepitude());
        sanctified = ModEnchantments.registerEnchantment(event, new EnchantmentSanctified());
        ruthless_strike = ModEnchantments.registerEnchantment(event, new EnchantmentRuthlessStrike());
    }

    private static Enchantment registerEnchantment(RegisterEvent event, TombstoneEnchantment enchantment) {
        ResourceLocation registryName = new ResourceLocation("tombstone", enchantment.getSimpleName());
        event.register(ForgeRegistries.Keys.ENCHANTMENTS, registryName, () -> enchantment);
        ENCHANTMENTS.put(registryName.toString(), enchantment);
        return enchantment;
    }

    public static Map<String, TombstoneEnchantment> getEnchantments() {
        return ENCHANTMENTS;
    }
}

