/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagnetMoveAction;
import org.violetmoon.quark.base.Quark;

public class MagnetizedBlockBlockEntity
extends BlockEntity {
    private BlockState magnetState;
    private CompoundTag subTile;
    private Direction magnetFacing;
    private static final ThreadLocal<Direction> MOVING_ENTITY = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;

    public MagnetizedBlockBlockEntity(BlockPos pos, BlockState state) {
        super(MagnetsModule.magnetizedBlockType, pos, state);
    }

    public MagnetizedBlockBlockEntity(BlockPos pos, BlockState state, BlockState magnetStateIn, CompoundTag subTileIn, Direction magnetFacingIn) {
        this(pos, state);
        this.magnetState = magnetStateIn;
        this.subTile = subTileIn;
        this.magnetFacing = magnetFacingIn;
    }

    public Direction getFacing() {
        return this.magnetFacing;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return Mth.m_14179_((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    public float getOffsetX(float ticks) {
        return (float)this.magnetFacing.m_122429_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.magnetFacing.m_122430_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.magnetFacing.m_122431_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float partialTicks) {
        return partialTicks - 1.0f;
    }

    private void moveCollidedEntities(float progress) {
        List boundingBoxes;
        AABB containingBox;
        List entities;
        if (this.f_58857_ == null) {
            return;
        }
        boolean sticky = Quark.ZETA.blockExtensions.get(this.magnetState).isStickyBlockZeta(this.magnetState);
        Direction direction = this.magnetFacing;
        double movement = progress - this.progress;
        VoxelShape collision = this.magnetState.m_60812_((BlockGetter)this.f_58857_, this.m_58899_());
        if (!collision.m_83281_() && !(entities = this.f_58857_.m_45933_(null, this.getMovementArea(containingBox = this.moveByPositionAndProgress(this.getEnclosingBox(boundingBoxes = collision.m_83299_())), direction, movement).m_82367_(containingBox))).isEmpty()) {
            for (Entity entity : entities) {
                AABB entityBox;
                AABB aList;
                AABB movementArea;
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                if (sticky) {
                    Vec3 motion = entity.m_20184_();
                    double dX = motion.f_82479_;
                    double dY = motion.f_82480_;
                    double dZ = motion.f_82481_;
                    switch (direction.m_122434_()) {
                        case X: {
                            dX = direction.m_122429_();
                            break;
                        }
                        case Y: {
                            dY = direction.m_122430_();
                            break;
                        }
                        case Z: {
                            dZ = direction.m_122431_();
                        }
                    }
                    entity.m_20334_(dX, dY, dZ);
                }
                double motion = 0.0;
                Iterator iterator = boundingBoxes.iterator();
                while (!(!iterator.hasNext() || (movementArea = this.getMovementArea(this.moveByPositionAndProgress(aList = (AABB)iterator.next()), direction, movement)).m_82381_(entityBox = entity.m_20191_()) && (motion = Math.max(motion, this.getMovement(movementArea, direction, entityBox))) >= movement)) {
                }
                if (!(motion > 0.0)) continue;
                motion = Math.min(motion, movement) + 0.01;
                MOVING_ENTITY.set(direction);
                entity.m_6478_(MoverType.PISTON, new Vec3(motion * (double)direction.m_122429_(), motion * (double)direction.m_122430_(), motion * (double)direction.m_122431_()));
                MOVING_ENTITY.set(null);
            }
        }
    }

    private AABB getEnclosingBox(List<AABB> boxes) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        for (AABB bb : boxes) {
            minX = Math.min(bb.f_82288_, minX);
            minY = Math.min(bb.f_82289_, minY);
            minZ = Math.min(bb.f_82290_, minZ);
            maxX = Math.max(bb.f_82291_, maxX);
            maxY = Math.max(bb.f_82292_, maxY);
            maxZ = Math.max(bb.f_82293_, maxZ);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private double getMovement(AABB bb1, Direction facing, AABB bb2) {
        return switch (facing.m_122434_()) {
            case Direction.Axis.X -> MagnetizedBlockBlockEntity.getDeltaX(bb1, facing, bb2);
            case Direction.Axis.Z -> MagnetizedBlockBlockEntity.getDeltaZ(bb1, facing, bb2);
            default -> MagnetizedBlockBlockEntity.getDeltaY(bb1, facing, bb2);
        };
    }

    private AABB moveByPositionAndProgress(AABB bb) {
        double progress = this.getExtendedProgress(this.progress);
        return bb.m_82386_((double)this.f_58858_.m_123341_() + progress * (double)this.magnetFacing.m_122429_(), (double)this.f_58858_.m_123342_() + progress * (double)this.magnetFacing.m_122430_(), (double)this.f_58858_.m_123343_() + progress * (double)this.magnetFacing.m_122431_());
    }

    private AABB getMovementArea(AABB bb, Direction dir, double movement) {
        double d0 = movement * (double)dir.m_122421_().m_122540_();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        return switch (dir) {
            case Direction.WEST -> new AABB(bb.f_82288_ + d1, bb.f_82289_, bb.f_82290_, bb.f_82288_ + d2, bb.f_82292_, bb.f_82293_);
            case Direction.EAST -> new AABB(bb.f_82291_ + d1, bb.f_82289_, bb.f_82290_, bb.f_82291_ + d2, bb.f_82292_, bb.f_82293_);
            case Direction.DOWN -> new AABB(bb.f_82288_, bb.f_82289_ + d1, bb.f_82290_, bb.f_82291_, bb.f_82289_ + d2, bb.f_82293_);
            case Direction.NORTH -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_ + d1, bb.f_82291_, bb.f_82292_, bb.f_82290_ + d2);
            case Direction.SOUTH -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82293_ + d1, bb.f_82291_, bb.f_82292_, bb.f_82293_ + d2);
            default -> new AABB(bb.f_82288_, bb.f_82292_ + d1, bb.f_82290_, bb.f_82291_, bb.f_82292_ + d2, bb.f_82293_);
        };
    }

    private static double getDeltaX(AABB bb1, Direction facing, AABB bb2) {
        return facing.m_122421_() == Direction.AxisDirection.POSITIVE ? bb1.f_82291_ - bb2.f_82288_ : bb2.f_82291_ - bb1.f_82288_;
    }

    private static double getDeltaY(AABB bb1, Direction facing, AABB bb2) {
        return facing.m_122421_() == Direction.AxisDirection.POSITIVE ? bb1.f_82292_ - bb2.f_82289_ : bb2.f_82292_ - bb1.f_82289_;
    }

    private static double getDeltaZ(AABB bb1, Direction facing, AABB bb2) {
        return facing.m_122421_() == Direction.AxisDirection.POSITIVE ? bb1.f_82293_ - bb2.f_82290_ : bb2.f_82293_ - bb1.f_82290_;
    }

    public BlockState getMagnetState() {
        return this.magnetState;
    }

    private IMagnetMoveAction getMoveAction() {
        Block block = this.magnetState.m_60734_();
        if (block instanceof IMagnetMoveAction) {
            IMagnetMoveAction moveAction = (IMagnetMoveAction)block;
            return moveAction;
        }
        return MagnetSystem.getMoveAction(block);
    }

    public void finalizeContents(BlockState blockState) {
        IMagnetMoveAction action;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        SoundType soundType = blockState.m_60827_();
        this.f_58857_.m_5594_(null, this.f_58858_, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) * 0.05f, soundType.m_56774_() * 0.8f);
        BlockEntity newTile = this.getSubTile(this.f_58858_);
        if (newTile != null) {
            this.f_58857_.m_151523_(newTile);
        }
        if ((action = this.getMoveAction()) != null) {
            action.onMagnetMoved(this.f_58857_, this.f_58858_, this.magnetFacing, blockState, newTile);
        }
    }

    public BlockEntity getSubTile(BlockPos pos) {
        if (this.subTile != null && !this.subTile.m_128456_()) {
            CompoundTag tileData = this.subTile.m_6426_();
            tileData.m_128405_("x", this.f_58858_.m_123341_());
            tileData.m_128405_("y", this.f_58858_.m_123342_());
            tileData.m_128405_("z", this.f_58858_.m_123343_());
            return BlockEntity.m_155241_((BlockPos)pos, (BlockState)this.magnetState, (CompoundTag)this.subTile);
        }
        return null;
    }

    public void clearMagnetTileEntity() {
        if (this.lastProgress < 1.0f && this.f_58857_ != null) {
            this.lastProgress = this.progress = 1.0f;
            this.f_58857_.m_46747_(this.f_58858_);
            this.m_7651_();
            if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.m_49931_((BlockState)this.magnetState, (LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
                this.setAndUpdateBlock(blockstate, 3);
            }
        }
    }

    private void setAndUpdateBlock(BlockState blockstate, int flag) {
        Level level;
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7731_(this.f_58858_, blockstate, flag);
        this.f_58857_.m_46586_(this.f_58858_, blockstate.m_60734_(), this.f_58858_);
        if ((blockstate.m_60734_() instanceof ButtonBlock || blockstate.m_60734_() instanceof BasePressurePlateBlock) && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockstate.m_222963_(serverLevel, this.f_58858_, serverLevel.f_46441_);
            blockstate = this.f_58857_.m_8055_(this.f_58858_);
        }
        this.finalizeContents(blockstate);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagnetizedBlockBlockEntity be) {
        be.tick();
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        this.lastTicked = this.f_58857_.m_46467_();
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.f_58857_.m_46747_(this.f_58858_);
            this.m_7651_();
            if (this.magnetState != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.m_49931_((BlockState)this.magnetState, (LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
                if (blockstate.m_60795_()) {
                    this.f_58857_.m_7731_(this.f_58858_, this.magnetState, 84);
                    Block.m_49902_((BlockState)this.magnetState, (BlockState)blockstate, (LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_, (int)3);
                } else {
                    if (blockstate.m_61148_().containsKey((Object)BlockStateProperties.f_61362_) && ((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                        blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE);
                    }
                    this.setAndUpdateBlock(blockstate, 67);
                }
            }
        } else {
            float newProgress = this.progress + 0.5f;
            this.moveCollidedEntities(newProgress);
            this.progress = newProgress;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.magnetState = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("blockState"));
        this.magnetFacing = Direction.m_122376_((int)compound.m_128451_("facing"));
        this.lastProgress = this.progress = compound.m_128457_("progress");
        this.subTile = compound.m_128469_("subTile");
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.writeNBTData(this.serializeNBT(), false);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeNBTData(nbt, true);
    }

    private CompoundTag writeNBTData(CompoundTag compound, boolean includeSubTile) {
        compound.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.magnetState));
        if (includeSubTile) {
            compound.m_128365_("subTile", (Tag)this.subTile);
        }
        compound.m_128405_("facing", this.magnetFacing.m_122411_());
        compound.m_128350_("progress", this.lastProgress);
        return compound;
    }

    public VoxelShape getCollisionShape(BlockGetter world, BlockPos pos) {
        Direction direction = MOVING_ENTITY.get();
        if ((double)this.progress < 1.0 && direction == this.magnetFacing) {
            return Shapes.m_83040_();
        }
        float progress = this.getExtendedProgress(this.progress);
        double dX = (float)this.magnetFacing.m_122429_() * progress;
        double dY = (float)this.magnetFacing.m_122430_() * progress;
        double dZ = (float)this.magnetFacing.m_122431_() * progress;
        return this.magnetState.m_60812_(world, pos).m_83216_(dX, dY, dZ);
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

