/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.emote;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.violetmoon.quark.content.tweaks.client.emote.CustomEmoteDescriptor;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteBase;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteDescriptor;
import org.violetmoon.quark.content.tweaks.client.emote.ModelAccessor;
import org.violetmoon.quark.content.tweaks.client.emote.TemplateSourcedEmote;

public final class EmoteHandler {
    public static final String CUSTOM_EMOTE_NAMESPACE = "quark_custom";
    public static final String CUSTOM_PREFIX = "custom:";
    public static final Map<String, EmoteDescriptor> emoteMap = new LinkedHashMap<String, EmoteDescriptor>();
    private static final Map<String, EmoteBase> playerEmotes = new HashMap<String, EmoteBase>();
    private static int count;

    public static void clearEmotes() {
        emoteMap.clear();
    }

    public static void addEmote(String name, Class<? extends EmoteBase> clazz) {
        EmoteDescriptor desc = new EmoteDescriptor(clazz, name, name, count++);
        emoteMap.put(name, desc);
    }

    public static void addEmote(String name) {
        EmoteHandler.addEmote(name, TemplateSourcedEmote.class);
    }

    public static void addCustomEmote(String name) {
        String reg = CUSTOM_PREFIX + name;
        CustomEmoteDescriptor desc = new CustomEmoteDescriptor(name, reg, count++);
        emoteMap.put(reg, desc);
    }

    public static void putEmote(Entity player, String emoteName, int tier) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            if (emoteMap.containsKey(emoteName)) {
                EmoteHandler.putEmote(clientPlayer, emoteMap.get(emoteName), tier);
            }
        }
    }

    private static void putEmote(AbstractClientPlayer player, EmoteDescriptor desc, int tier) {
        String name = player.m_36316_().getName();
        if (desc == null) {
            return;
        }
        if (desc.getTier() > tier) {
            return;
        }
        HumanoidModel<?> model = EmoteHandler.getPlayerModel(player);
        HumanoidModel<?> armorModel = EmoteHandler.getPlayerArmorModel(player);
        HumanoidModel<?> armorLegModel = EmoteHandler.getPlayerArmorLegModel(player);
        if (model != null && armorModel != null && armorLegModel != null) {
            EmoteHandler.resetPlayer(player);
            EmoteBase emote = desc.instantiate((Player)player, model, armorModel, armorLegModel);
            emote.startAllTimelines();
            playerEmotes.put(name, emote);
        }
    }

    public static void updateEmotes(Entity e) {
        if (e instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)e;
            String name = player.m_36316_().getName();
            if (player.m_20089_() == Pose.STANDING && playerEmotes.containsKey(name)) {
                EmoteHandler.resetPlayer(player);
                EmoteBase emote = playerEmotes.get(name);
                boolean done = emote.isDone();
                if (!done) {
                    emote.update();
                }
            }
        }
    }

    public static void preRender(PoseStack stack, Player player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            stack.m_85836_();
            emote.rotateAndOffset(stack);
        }
    }

    public static void postRender(PoseStack stack, Player player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            stack.m_85849_();
        }
    }

    public static void onRenderTick(Minecraft mc) {
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        for (Player player : world.m_6907_()) {
            EmoteHandler.updatePlayerStatus(player);
        }
    }

    private static void updatePlayerStatus(Player e) {
        AbstractClientPlayer player;
        String name;
        if (e instanceof AbstractClientPlayer && playerEmotes.containsKey(name = (player = (AbstractClientPlayer)e).m_36316_().getName())) {
            EmoteBase emote = playerEmotes.get(name);
            boolean done = emote.isDone();
            if (done) {
                playerEmotes.remove(name);
                EmoteHandler.resetPlayer(player);
            } else {
                emote.update();
            }
        }
    }

    public static EmoteBase getPlayerEmote(Player player) {
        return playerEmotes.get(player.m_36316_().getName());
    }

    private static PlayerRenderer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher manager = mc.m_91290_();
        EntityRenderer render = (EntityRenderer)manager.getSkinMap().get(player.m_108564_());
        if (render instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)render;
            return playerRenderer;
        }
        return null;
    }

    private static HumanoidModel<?> getPlayerModel(AbstractClientPlayer player) {
        PlayerRenderer render = EmoteHandler.getRenderPlayer(player);
        if (render != null) {
            return (HumanoidModel)render.m_7200_();
        }
        return null;
    }

    private static HumanoidModel<?> getPlayerArmorModel(AbstractClientPlayer player) {
        return EmoteHandler.getPlayerArmorModelForSlot(player, EquipmentSlot.CHEST);
    }

    private static HumanoidModel<?> getPlayerArmorLegModel(AbstractClientPlayer player) {
        return EmoteHandler.getPlayerArmorModelForSlot(player, EquipmentSlot.LEGS);
    }

    private static HumanoidModel<?> getPlayerArmorModelForSlot(AbstractClientPlayer player, EquipmentSlot slot) {
        PlayerRenderer render = EmoteHandler.getRenderPlayer(player);
        if (render == null) {
            return null;
        }
        List list = render.f_115291_;
        for (RenderLayer r : list) {
            if (!(r instanceof HumanoidArmorLayer)) continue;
            return ((HumanoidArmorLayer)r).m_117078_(slot);
        }
        return null;
    }

    private static void resetPlayer(AbstractClientPlayer player) {
        EmoteHandler.resetModel(EmoteHandler.getPlayerModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel(player));
    }

    private static void resetModel(HumanoidModel<?> model) {
        if (model != null) {
            EmoteHandler.resetPart(model.f_102808_);
            EmoteHandler.resetPart(model.f_102809_);
            EmoteHandler.resetPart(model.f_102810_);
            EmoteHandler.resetPart(model.f_102812_);
            EmoteHandler.resetPart(model.f_102811_);
            EmoteHandler.resetPart(model.f_102814_);
            EmoteHandler.resetPart(model.f_102813_);
            if (model instanceof PlayerModel) {
                PlayerModel pmodel = (PlayerModel)model;
                EmoteHandler.resetPart(pmodel.f_103378_);
                EmoteHandler.resetPart(pmodel.f_103374_);
                EmoteHandler.resetPart(pmodel.f_103375_);
                EmoteHandler.resetPart(pmodel.f_103376_);
                EmoteHandler.resetPart(pmodel.f_103377_);
            }
            ModelAccessor.INSTANCE.resetModel(model);
        }
    }

    private static void resetPart(ModelPart part) {
        if (part != null) {
            part.f_104205_ = 0.0f;
        }
    }
}

