/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader;

import net.creeperhost.levelio.loader.SaveInfo;

public enum LevelType {
    OVERWORLD("minecraft:overworld"),
    THE_NETHER("minecraft:the_nether"),
    THE_END("minecraft:the_end"),
    CUSTOM(null);

    private final String name;

    private LevelType(String name) {
        this.name = name;
    }

    public static LevelType getType(String identifier) {
        for (LevelType value : LevelType.values()) {
            if (!identifier.equals(value.name)) continue;
            return value;
        }
        if ("0".equals(identifier)) {
            return OVERWORLD;
        }
        if ("1".equals(identifier)) {
            return THE_END;
        }
        if ("-1".equals(identifier)) {
            return THE_NETHER;
        }
        return CUSTOM;
    }

    public static LevelType fromDimId(int dimId) {
        switch (dimId) {
            case -1: {
                return THE_NETHER;
            }
            case 0: {
                return OVERWORLD;
            }
            case 1: {
                return THE_END;
            }
        }
        return CUSTOM;
    }

    public static String mapDimId(SaveInfo saveInfo, int dimId) {
        if (saveInfo.hasDimNames()) {
            switch (dimId) {
                case -1: {
                    return LevelType.THE_NETHER.name;
                }
                case 0: {
                    return LevelType.OVERWORLD.name;
                }
                case 1: {
                    return LevelType.THE_END.name;
                }
            }
        }
        return String.valueOf(dimId);
    }
}

