/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib;

import java.util.HashMap;
import java.util.Map;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelpreview.lib.CaptureArea;

public class Cluster {
    private final ChunkPos origin;
    private final Level level;
    public Map<ChunkPos, Double> chunks = new HashMap<ChunkPos, Double>();
    public int diameter;
    public double totalHabTime;

    public Cluster(ChunkPos origin, Level level) {
        this.origin = origin;
        this.level = level;
    }

    public Cluster finalize(int searchRadChunks) {
        this.diameter = (1 + searchRadChunks * 2) * 16;
        this.totalHabTime = FastStream.of(this.chunks.values()).doubleSum(e -> e);
        return this;
    }

    public double getClusterWeight(double avgDiameter, double avgHabTime) {
        double diamVal = (double)this.diameter / avgDiameter;
        double timeVal = this.totalHabTime / avgHabTime;
        return diamVal * 0.5 + timeVal * 1.5;
    }

    private BlockPos weightedAveragePos() {
        double x = 0.0;
        double xSum = 0.0;
        double z = 0.0;
        double zSum = 0.0;
        for (ChunkPos pos : this.chunks.keySet()) {
            double weight = this.chunks.get(pos);
            x += (double)(pos.x << 4) * weight;
            xSum += weight;
            z += (double)(pos.z << 4) * weight;
            zSum += weight;
        }
        return new BlockPos((int)(x / xSum), 0, (int)(z / zSum));
    }

    public CaptureArea trimAndFinish(int minSize, int maxSize) {
        BlockPos origin = new BlockPos((this.origin.x << 4) + 8, 0, (this.origin.z << 4) + 8);
        BlockPos focus = this.weightedAveragePos();
        int diameter = Math.min(this.diameter, maxSize);
        int rad = diameter / 2;
        int minRad = minSize / 2;
        focus.x = Cluster.clamp(focus.x, origin.x - rad + minRad, origin.x + rad - minRad);
        focus.z = Cluster.clamp(focus.z, origin.z - rad + minRad, origin.z + rad - minRad);
        int offset = Math.max(minSize, diameter) / 2;
        CaptureArea area = new CaptureArea(this.level, focus.copy().offset(-offset, 0, -offset), focus.offset(offset, 0, offset));
        area.setChunksTime(this.chunks);
        area.totalHabTime = this.totalHabTime;
        return area;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public String toString() {
        return "Cluster{origin=" + this.origin + ", diameter=" + this.diameter + ", totalHabTime=" + this.totalHabTime + '}';
    }
}

