/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftbquests.client.GuiProviders;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class RewardType {
    private final ResourceLocation typeId;
    private final Provider provider;
    private final Supplier<Icon> iconSupplier;
    private Component displayName;
    private GuiProvider guiProvider;
    private boolean excludeFromListRewards = false;
    public int intId;

    public RewardType(ResourceLocation typeId, Provider provider, Supplier<Icon> iconSupplier) {
        this.typeId = typeId;
        this.provider = provider;
        this.iconSupplier = iconSupplier;
        this.displayName = null;
        this.guiProvider = GuiProviders.defaultRewardGuiProvider(provider);
    }

    @Nullable
    public static Reward createReward(long id, Quest quest, String typeId) {
        if (((String)typeId).isEmpty()) {
            typeId = "ftbquests:item";
        } else if (((String)typeId).indexOf(58) == -1) {
            typeId = "ftbquests:" + (String)typeId;
        }
        RewardType type = RewardTypes.TYPES.get(new ResourceLocation((String)typeId));
        return type == null ? null : type.provider.create(id, quest);
    }

    public ResourceLocation getTypeId() {
        return this.typeId;
    }

    public Reward createReward(long id, Quest quest) {
        return this.provider.create(id, quest);
    }

    public String getTypeForNBT() {
        return this.typeId.m_135827_().equals("ftbquests") ? this.typeId.m_135815_() : this.typeId.toString();
    }

    public RewardType setDisplayName(Component name) {
        this.displayName = name;
        return this;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)("ftbquests.reward." + this.typeId.m_135827_() + "." + this.typeId.m_135815_()));
        }
        return this.displayName;
    }

    public Icon getIconSupplier() {
        return this.iconSupplier.get();
    }

    public RewardType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public RewardType setExcludeFromListRewards(boolean v) {
        this.excludeFromListRewards = v;
        return this;
    }

    public boolean getExcludeFromListRewards() {
        return this.excludeFromListRewards;
    }

    @FunctionalInterface
    public static interface Provider {
        public Reward create(long var1, Quest var3);
    }

    @FunctionalInterface
    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Panel var1, Quest var2, Consumer<Reward> var3);
    }
}

