/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public enum UserLevel implements Predicate<CommandSourceStack>
{
    OP,
    OWNER_OP,
    ANYONE;


    public int toLevel() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OP, OWNER_OP -> 2;
            case ANYONE -> 0;
        };
    }

    @Override
    public boolean test(CommandSourceStack source) {
        if (this == ANYONE) {
            return true;
        }
        if (this == OWNER_OP && UserLevel.isOwner(source)) {
            return true;
        }
        return source.m_6761_(this.toLevel());
    }

    @Override
    public boolean test(ServerPlayer source) {
        if (this == ANYONE) {
            return true;
        }
        if (this == OWNER_OP && UserLevel.isOwner(source)) {
            return true;
        }
        return source.m_20310_(this.toLevel());
    }

    public static boolean isOwner(CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        if (server == null) {
            return false;
        }
        ServerPlayer player = source.m_230896_();
        return server.m_6982_() ? source.m_81373_() == null && source.m_6761_(4) && source.m_81368_().equals("Server") : player != null && server.m_7779_(player.m_36316_());
    }

    public static boolean isOwner(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        return server != null && server.m_7779_(player.m_36316_());
    }
}

