/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.container;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ContainerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ComputerContainerData
implements ContainerData {
    private final ComputerFamily family;
    private final TerminalState terminal;
    private final ItemStack displayStack;
    private final int uploadMaxSize;

    public ComputerContainerData(ServerComputer computer, ItemStack displayStack) {
        this.family = computer.getFamily();
        this.terminal = computer.getTerminalState();
        this.displayStack = displayStack;
        this.uploadMaxSize = Config.uploadMaxSize;
    }

    public ComputerContainerData(FriendlyByteBuf buf) {
        this.family = (ComputerFamily)buf.m_130066_(ComputerFamily.class);
        this.terminal = new TerminalState(buf);
        this.displayStack = buf.m_130267_();
        this.uploadMaxSize = buf.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.family);
        this.terminal.write(buf);
        buf.m_130055_(this.displayStack);
        buf.writeInt(this.uploadMaxSize);
    }

    public ComputerFamily family() {
        return this.family;
    }

    public TerminalState terminal() {
        return this.terminal;
    }

    public ItemStack displayStack() {
        return this.displayStack;
    }

    public int uploadMaxSize() {
        return this.uploadMaxSize;
    }
}

