/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NBTUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NBTUtil.class);
    @VisibleForTesting
    static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();
    private static final CompoundTag EMPTY_TAG;

    private NBTUtil() {
    }

    public static CompoundTag emptyTag() {
        if (EMPTY_TAG.m_128440_() != 0) {
            LOG.error("The empty tag has been modified.");
        }
        return EMPTY_TAG;
    }

    public static CompoundTag getCompoundOrEmpty(CompoundTag tag, String key) {
        Tag childTag = tag.m_128423_(key);
        return childTag != null && childTag.m_7060_() == 10 ? (CompoundTag)childTag : NBTUtil.emptyTag();
    }

    public static @Nullable Object toLua(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        return switch (tag.m_7060_()) {
            case 1, 2, 3, 4 -> ((NumericTag)tag).m_7046_();
            case 5, 6 -> ((NumericTag)tag).m_7061_();
            case 8 -> tag.m_7916_();
            case 10 -> {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.m_128440_());
                for (String key : compound.m_128431_()) {
                    Object value = NBTUtil.toLua(compound.m_128423_(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                yield map;
            }
            case 9 -> ((ListTag)tag).stream().map(NBTUtil::toLua).toList();
            case 7 -> {
                byte[] array = ((ByteArrayTag)tag).m_128227_();
                ArrayList<Byte> map = new ArrayList<Byte>(array.length);
                for (byte b : array) {
                    map.add(b);
                }
                yield map;
            }
            case 11 -> Arrays.stream(((IntArrayTag)tag).m_128648_()).boxed().toList();
            case 12 -> Arrays.stream(((LongArrayTag)tag).m_128851_()).boxed().toList();
            default -> null;
        };
    }

    public static @Nullable String getNBTHash(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NBTUtil.writeNamedTag(output, "", (Tag)tag);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOG.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static void writeNamedTag(DataOutput output, String name, Tag tag) throws IOException {
        output.writeByte(tag.m_7060_());
        if (tag.m_7060_() == 0) {
            return;
        }
        output.writeUTF(name);
        NBTUtil.writeTag(output, tag);
    }

    private static void writeTag(DataOutput output, Tag tag) throws IOException {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            Object[] keys = compound.m_128431_().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtil.writeNamedTag(output, (String)key, Nullability.assertNonNull(compound.m_128423_((String)key)));
            }
            output.writeByte(0);
        } else if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            output.writeByte(list.isEmpty() ? 0 : (int)list.get(0).m_7060_());
            output.writeInt(list.size());
            for (Tag value : list) {
                NBTUtil.writeTag(output, value);
            }
        } else {
            tag.m_6434_(output);
        }
    }

    static {
        if (PlatformHelper.get().isDevelopmentEnvironment()) {
            try {
                Constructor ctor = CompoundTag.class.getDeclaredConstructor(Map.class);
                ctor.setAccessible(true);
                EMPTY_TAG = (CompoundTag)ctor.newInstance(Map.of());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            EMPTY_TAG = new CompoundTag();
        }
    }

    @VisibleForTesting
    static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

