/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capability;

import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class AcceptingFluidItemHandler
extends FluidHandlerItemStack {
    private final Predicate<Fluid> fluidPredicate;

    public AcceptingFluidItemHandler(ItemStack container, int capacity, Fluid validFluid) {
        this(container, capacity, (Fluid fluid) -> fluid == validFluid);
    }

    public AcceptingFluidItemHandler(ItemStack container, int capacity, TagKey<Fluid> validFluid) {
        this(container, capacity, (Fluid fluid) -> fluid.m_205067_(validFluid));
    }

    public AcceptingFluidItemHandler(ItemStack container, int capacity, Predicate<Fluid> isFluidValid) {
        super(container, capacity);
        this.fluidPredicate = isFluidValid;
    }

    public void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.fluidPredicate.test(fluid.getFluid());
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.fluidPredicate.test(stack.getFluid());
    }
}

