/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.enchantment;

import com.enderio.base.common.init.EIOEnchantments;
import com.google.common.base.Throwables;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class XPBoostHandler {
    private static final String NBT_KEY = "EnderIOXpBoostLevel";

    @SubscribeEvent
    public static void handleExperienceDropEvent(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null) {
            Entity entity;
            DamageSource lastDamageSource = event.getEntity().m_21225_();
            int xpBoost = 0;
            if (lastDamageSource != null && (entity = lastDamageSource.m_7640_()) instanceof Arrow) {
                Arrow arrow = (Arrow)entity;
                CompoundTag tag = arrow.getPersistentData();
                if (tag.m_128441_(NBT_KEY) && tag.m_128451_(NBT_KEY) >= 0) {
                    int level = tag.m_128451_(NBT_KEY);
                    xpBoost = XPBoostHandler.getXPBoost(event.getEntity(), level);
                }
            } else {
                xpBoost = XPBoostHandler.getXPBoost(event.getEntity(), event.getAttackingPlayer());
            }
            if (xpBoost > 0) {
                event.setDroppedExperience(event.getDroppedExperience() + xpBoost);
            }
        }
    }

    @SubscribeEvent
    public static void handleArrowFire(EntityJoinLevelEvent event) {
        Arrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof Arrow && (arrow = (Arrow)entity).m_19749_() != null) {
            arrow.getPersistentData().m_128405_(NBT_KEY, XPBoostHandler.getXPBoostLevel(arrow.m_19749_()));
        }
    }

    @SubscribeEvent
    public static void handleBlockBreak(BlockEvent.BreakEvent event) {
        int boostLevel = XPBoostHandler.getXPBoostLevel((Entity)event.getPlayer());
        if (boostLevel >= 0) {
            BlockState state = event.getState();
            Level level = (Level)event.getLevel();
            BlockPos pos = event.getPos();
            int fortune = event.getPlayer().m_21205_().getEnchantmentLevel(Enchantments.f_44987_);
            int xp = state.m_60734_().getExpDrop(state, (LevelReader)level, RandomSource.m_216327_(), pos, fortune, 0);
            if (xp > 0) {
                level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, XPBoostHandler.getXPBoost(xp, boostLevel)));
            }
        }
    }

    private static int getXPBoost(LivingEntity killed, Player player) {
        return XPBoostHandler.getXPBoost(killed, XPBoostHandler.getXPBoostLevel((Entity)player));
    }

    private static int getXPBoost(LivingEntity killed, int level) {
        if (level >= 0) {
            try {
                int xp = killed.m_213860_();
                return XPBoostHandler.getXPBoost(xp, level);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
            }
        }
        return 0;
    }

    private static int getXPBoost(int xp, int level) {
        return Math.round((float)xp * ((float)Math.log10(level + 1) * 2.0f));
    }

    private static int getXPBoostLevel(Entity entity) {
        Player player;
        if (entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            ItemStack weapon = player.m_21205_();
            if (weapon.m_41619_()) {
                return -1;
            }
            int result = -1;
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)weapon).entrySet()) {
                if (entry.getKey() == Enchantments.f_44985_) {
                    return -1;
                }
                if (entry.getKey() != EIOEnchantments.XP_BOOST.get()) continue;
                result = (Integer)entry.getValue();
            }
            return result;
        }
        return -1;
    }
}

