/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.integrations.jei;

import com.enderio.base.common.network.C2SSetFluidFilterSlot;
import com.enderio.base.common.network.C2SSetItemFilterSlot;
import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.core.common.menu.FilterSlot;
import com.enderio.core.common.menu.FluidFilterSlot;
import com.enderio.core.common.menu.ItemFilterSlot;
import com.enderio.core.common.network.CoreNetwork;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FilterGhostIngredientHandler
implements IGhostIngredientHandler<EIOScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(EIOScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        AbstractContainerMenu menu = gui.m_6262_();
        for (int i = 0; i < menu.f_38839_.size(); ++i) {
            Slot slot = menu.m_38853_(i);
            if (!slot.m_6659_()) continue;
            Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 17, 17);
            if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
                FilterSlot otherFilterSlot;
                ItemStack currentIngredient = (ItemStack)ingredient.getIngredient();
                if (slot instanceof ItemFilterSlot) {
                    ItemFilterSlot itemFilterSlot = (ItemFilterSlot)slot;
                    targets.add(new ItemStackTarget(bounds, menu.f_38840_, i, itemFilterSlot));
                    continue;
                }
                if (!(slot instanceof FilterSlot) || !(otherFilterSlot = (FilterSlot)slot).getResourceFrom(currentIngredient).isPresent()) continue;
                targets.add(new IndirectItemStackTarget(bounds, menu.f_38840_, i, otherFilterSlot));
                continue;
            }
            if (ingredient.getType() != ForgeTypes.FLUID_STACK || !(slot instanceof FluidFilterSlot)) continue;
            FluidFilterSlot fluidFilterSlot = (FluidFilterSlot)slot;
            targets.add(new FluidStackTarget(bounds, menu.f_38840_, i, fluidFilterSlot));
        }
        return targets;
    }

    public void onComplete() {
    }

    private record ItemStackTarget<I>(Rect2i bounds, int containerId, int slotIndex, ItemFilterSlot slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.setResource((ItemStack)ingredient);
            CoreNetwork.sendToServer(new C2SSetItemFilterSlot(this.containerId, this.slotIndex, (ItemStack)ingredient));
        }
    }

    private record IndirectItemStackTarget<I>(Rect2i bounds, int containerId, int slotIndex, FilterSlot<?> slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.m_150659_((ItemStack)ingredient);
            CoreNetwork.sendToServer(new C2SSetItemFilterSlot(this.containerId, this.slotIndex, (ItemStack)ingredient));
        }
    }

    private record FluidStackTarget<I>(Rect2i bounds, int containerId, int slotIndex, FluidFilterSlot slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.setResource((FluidStack)ingredient);
            CoreNetwork.sendToServer(new C2SSetFluidFilterSlot(this.containerId, this.slotIndex, (FluidStack)ingredient));
        }
    }
}

