/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.misc;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.capability.EntityStorageItemStack;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.util.EntityCaptureUtils;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class BrokenSpawnerItem
extends Item
implements IMultiCapabilityItem {
    public BrokenSpawnerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack forType(ResourceLocation type) {
        ItemStack brokenSpawner = new ItemStack((ItemLike)EIOItems.BROKEN_SPAWNER.get());
        BrokenSpawnerItem.setEntityType(brokenSpawner, type);
        return brokenSpawner;
    }

    public static List<ItemStack> gePossibleStacks() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ResourceLocation entity : EntityCaptureUtils.getCapturableEntities()) {
            items.add(BrokenSpawnerItem.forType(entity));
        }
        return items;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        BrokenSpawnerItem.getEntityType(pStack).ifPresent(type -> pTooltipComponents.add(TooltipUtil.style(Component.m_237115_((String)EntityUtil.getEntityDescriptionId(type)))));
    }

    public static Optional<ResourceLocation> getEntityType(ItemStack stack) {
        return stack.getCapability(EIOCapabilities.ENTITY_STORAGE).map(storage -> storage.getStoredEntityData().getEntityType()).orElse(Optional.empty());
    }

    private static void setEntityType(ItemStack stack, ResourceLocation entityType) {
        stack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(entityType)));
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(EIOCapabilities.ENTITY_STORAGE, LazyOptional.of(() -> new EntityStorageItemStack(stack)));
        return provider;
    }
}

