/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.misc;

import com.enderio.api.capability.CoordinateSelection;
import com.enderio.api.capability.ICoordinateSelectionHolder;
import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.capability.CoordinateSelectionHolder;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.menu.CoordinateMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LocationPrintoutItem
extends Item
implements IMultiCapabilityItem {
    public LocationPrintoutItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Optional<CoordinateSelection> optionalSelection = LocationPrintoutItem.getSelection(pContext.m_43722_());
        if (optionalSelection.isPresent() && pContext.m_43723_() != null && pContext.m_43723_().m_6047_()) {
            Player player = pContext.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LocationPrintoutItem.handleRightClick(serverPlayer, optionalSelection.get(), pContext.m_43722_());
            }
            return InteractionResult.m_19078_((boolean)pContext.m_43725_().f_46443_);
        }
        return super.m_6225_(pContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        Optional<CoordinateSelection> optionalSelection = LocationPrintoutItem.getSelection(itemInHand);
        if (optionalSelection.isPresent() && pPlayer.m_6047_()) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                CoordinateSelection selection = optionalSelection.get();
                LocationPrintoutItem.handleRightClick(serverPlayer, selection, itemInHand);
            }
            return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)pLevel.f_46443_);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    private static void handleRightClick(ServerPlayer serverPlayer, @Nullable CoordinateSelection selection, ItemStack printout) {
        if (selection != null) {
            LocationPrintoutItem.openMenu(serverPlayer, selection, printout.m_41786_().getString());
        }
    }

    private static void openMenu(ServerPlayer player, final CoordinateSelection selection, final String name) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237119_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
                return new CoordinateMenu(pContainerId, selection, name);
            }
        }, buf -> CoordinateMenu.writeAdditionalData(buf, selection, name));
    }

    public static Optional<CoordinateSelection> getSelection(ItemStack stack) {
        return stack.getCapability(EIOCapabilities.COORDINATE_SELECTION_HOLDER).filter(ICoordinateSelectionHolder::hasSelection).map(ICoordinateSelectionHolder::getSelection);
    }

    public static void setSelection(ItemStack stack, CoordinateSelection selection) {
        stack.getCapability(EIOCapabilities.COORDINATE_SELECTION_HOLDER).ifPresent(selectionHolder -> selectionHolder.setSelection(selection));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> toolTip, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, toolTip, pIsAdvanced);
        LocationPrintoutItem.getSelection(pStack).ifPresent(selection -> {
            toolTip.add((Component)LocationPrintoutItem.writeCoordinate('x', selection.pos().m_123341_()).m_7220_((Component)LocationPrintoutItem.writeCoordinate('y', selection.pos().m_123342_())).m_7220_((Component)LocationPrintoutItem.writeCoordinate('z', selection.pos().m_123343_())));
            toolTip.add((Component)Component.m_237113_((String)selection.getLevelName()));
        });
    }

    private static MutableComponent writeCoordinate(char character, int number) {
        return Component.m_237113_((String)("" + character)).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("" + number)).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(EIOCapabilities.COORDINATE_SELECTION_HOLDER, LazyOptional.of(() -> new CoordinateSelectionHolder(stack)));
        return provider;
    }
}

