/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.network;

import com.enderio.core.common.menu.FluidFilterSlot;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record C2SSetFluidFilterSlot(int containerId, int slotIndex, FluidStack fluidStack) implements Packet
{
    public C2SSetFluidFilterSlot(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readFluidStack());
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        if (context.getSender() == null) {
            return false;
        }
        AbstractContainerMenu menu = context.getSender().f_36096_;
        return menu != null && menu.f_38840_ == this.containerId && this.slotIndex < menu.f_38839_.size();
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Slot slot = context.getSender().f_36096_.m_38853_(this.slotIndex);
        if (slot instanceof FluidFilterSlot) {
            FluidFilterSlot filterSlot = (FluidFilterSlot)slot;
            filterSlot.setResource(this.fluidStack);
        }
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.writeInt(this.containerId);
        writeInto.writeInt(this.slotIndex);
        writeInto.writeFluidStack(this.fluidStack);
    }

    public static class Handler
    extends Packet.PacketHandler<C2SSetFluidFilterSlot> {
        @Override
        public C2SSetFluidFilterSlot fromNetwork(FriendlyByteBuf buf) {
            return new C2SSetFluidFilterSlot(buf);
        }

        @Override
        public void toNetwork(C2SSetFluidFilterSlot packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

