/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.mekanism;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.conduits.common.integrations.Integrations;
import java.util.List;
import mekanism.api.heat.IHeatHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;

public class HeatTicker
extends CapabilityAwareConduitTicker<ConduitData.EmptyConduitData, IHeatHandler> {
    @Override
    protected void tickCapabilityGraph(ServerLevel level, ConduitType<ConduitData.EmptyConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<ConduitData.EmptyConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IHeatHandler extractHandler = (IHeatHandler)extract.capability;
            for (CapabilityAwareConduitTicker.CapabilityConnection insert : inserts) {
                IHeatHandler insertHandler = (IHeatHandler)insert.capability;
                double heatCapacity = extractHandler.getTotalHeatCapacity();
                double invConduction = insertHandler.getTotalInverseConduction() + extractHandler.getTotalInverseConduction();
                double tempToTransfer = (extractHandler.getTotalTemperature() - insertHandler.getTotalTemperature()) / invConduction;
                double heatToTransfer = tempToTransfer * heatCapacity;
                if (!(heatToTransfer > 0.0)) continue;
                extractHandler.handleHeat(-heatToTransfer);
                insertHandler.handleHeat(heatToTransfer);
            }
        }
    }

    @Override
    protected Capability<IHeatHandler> getCapability() {
        return Integrations.MEKANISM_INTEGRATION.expectPresent().HEAT_HANDLER;
    }
}

