/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widgets;

import com.enderio.api.misc.Vector2i;
import com.enderio.core.EnderCore;
import com.enderio.core.client.gui.widgets.MultiIconButtonType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MultiIconButton
extends AbstractButton {
    private final Supplier<Integer> getter;
    private final Consumer<Integer> setter;
    private static final ResourceLocation MULTI_ICON_TEXTURE = EnderCore.loc("textures/gui/multi_icon.png");
    private final ResourceLocation texture;
    private final MultiIconButtonType type;

    public MultiIconButton(ResourceLocation texture, Vector2i pos, Supplier<Integer> getter, Consumer<Integer> setter, MultiIconButtonType type) {
        this(texture, pos, 8, 8, getter, setter, (Component)Component.m_237119_(), type);
    }

    public MultiIconButton(ResourceLocation texture, Vector2i pos, int width, int height, Supplier<Integer> getter, Consumer<Integer> setter, Component message, MultiIconButtonType type) {
        super(pos.x(), pos.y(), width, height, message);
        this.getter = getter;
        this.setter = setter;
        this.texture = texture;
        this.type = type;
    }

    public void m_5691_() {
        int increment = 1;
        if (Screen.m_96638_()) {
            increment = 10;
        }
        if (Screen.m_96637_()) {
            increment = 100;
        }
        if (this.type == MultiIconButtonType.PLUS_BUTTON) {
            this.setter.accept(this.getter.get() + increment);
        } else if (this.type == MultiIconButtonType.MINUS_BUTTON) {
            this.setter.accept(this.getter.get() - increment);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int textureX = 0;
        int textureY = 0;
        if (this.type == MultiIconButtonType.MINUS_BUTTON) {
            textureX = 16;
        }
        if (this.m_274382_()) {
            textureY = 16;
        }
        guiGraphics.m_280411_(this.texture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, (float)textureX, (float)textureY, this.f_93618_ * 2, this.f_93619_ * 2, 256, 256);
    }

    public static MultiIconButton createAddButton(Vector2i pos, Supplier<Integer> getter, Consumer<Integer> setter) {
        return new MultiIconButton(MULTI_ICON_TEXTURE, pos, getter, setter, MultiIconButtonType.PLUS_BUTTON);
    }

    public static MultiIconButton createMinusButton(Vector2i pos, Supplier<Integer> getter, Consumer<Integer> setter) {
        return new MultiIconButton(MULTI_ICON_TEXTURE, pos, getter, setter, MultiIconButtonType.MINUS_BUTTON);
    }
}

