/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class ChunkBoundLookup<T> {
    private final Long2ObjectMap<Set<T>> chunkData = new Long2ObjectOpenHashMap();
    private final Reference2ObjectMap<T, Set<ChunkPos>> valueKeys = new Reference2ObjectOpenHashMap();

    @Nullable
    public Set<T> getForChunk(ChunkPos pos) {
        return (Set)this.chunkData.get(pos.m_45588_());
    }

    public void addToChunk(ChunkPos pos, T value) {
        ((Set)this.chunkData.computeIfAbsent(pos.m_45588_(), k -> new HashSet())).add(value);
        ((Set)this.valueKeys.computeIfAbsent(value, k -> new HashSet())).add(pos);
    }

    public void removeFromChunk(ChunkPos pos, T value) {
        if (this.chunkData.containsKey(pos.m_45588_())) {
            ((Set)this.chunkData.get(pos.m_45588_())).remove(value);
        }
        if (this.valueKeys.containsKey(value)) {
            ((Set)this.valueKeys.get(value)).remove(pos);
        }
    }

    public void addForBlockRadius(BlockPos centerPos, int blockRadius, T value) {
        this.getBlockRadius(centerPos, blockRadius).forEach(chunkPos -> this.addToChunk((ChunkPos)chunkPos, value));
    }

    public void updateForBlockRadius(BlockPos centerPos, int blockRadius, T value) {
        Set currentChunks = (Set)this.valueKeys.get(value);
        if (currentChunks == null) {
            this.addForBlockRadius(centerPos, blockRadius, value);
            return;
        }
        Set<ChunkPos> newChunks = this.getBlockRadius(centerPos, blockRadius).collect(Collectors.toSet());
        this.bulkUpdate(value, currentChunks, newChunks);
    }

    public void addForChunkRadius(ChunkPos centerPos, int chunkRadius, T value) {
        ChunkPos.m_45596_((ChunkPos)centerPos, (int)chunkRadius).forEach(chunkPos -> this.addToChunk((ChunkPos)chunkPos, value));
    }

    public void updateForChunkRadius(ChunkPos centerPos, int chunkRadius, T value) {
        Set currentChunks = (Set)this.valueKeys.get(value);
        if (currentChunks == null) {
            this.addForChunkRadius(centerPos, chunkRadius, value);
            return;
        }
        Set<ChunkPos> newChunks = ChunkPos.m_45596_((ChunkPos)centerPos, (int)chunkRadius).collect(Collectors.toSet());
        this.bulkUpdate(value, currentChunks, newChunks);
    }

    private Stream<ChunkPos> getBlockRadius(BlockPos centerPos, int blockRadius) {
        BlockPos startBlockPos = new BlockPos(centerPos.m_123341_() - blockRadius, 0, centerPos.m_123343_() - blockRadius);
        BlockPos endBlockPos = new BlockPos(centerPos.m_123341_() + blockRadius, 0, centerPos.m_123343_() + blockRadius);
        ChunkPos startChunkPos = new ChunkPos(startBlockPos);
        ChunkPos endChunkPos = new ChunkPos(endBlockPos);
        return ChunkPos.m_45599_((ChunkPos)startChunkPos, (ChunkPos)endChunkPos);
    }

    private void bulkUpdate(T value, Set<ChunkPos> chunksBefore, Set<ChunkPos> chunksAfter) {
        Sets.SetView removedChunks = Sets.difference(chunksBefore, chunksAfter);
        Sets.SetView addedChunks = Sets.difference(chunksAfter, chunksBefore);
        removedChunks.forEach(chunkPos -> this.removeFromChunk((ChunkPos)chunkPos, value));
        addedChunks.forEach(chunkPos -> this.addToChunk((ChunkPos)chunkPos, value));
    }

    public void remove(T value) {
        Set chunks = (Set)this.valueKeys.get(value);
        for (ChunkPos chunkPos : chunks) {
            Set dataAtChunk = (Set)this.chunkData.get(chunkPos.m_45588_());
            if (dataAtChunk == null) continue;
            dataAtChunk.remove(value);
            if (!dataAtChunk.isEmpty()) continue;
            this.chunkData.remove(chunkPos.m_45588_());
        }
        this.valueKeys.remove(value);
    }
}

