/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.base;

import com.enderio.api.capacitor.ICapacitorScalable;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.particle.RangeParticleData;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.io.SidedFixedIOConfig;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class ObeliskBlockEntity
extends PoweredMachineBlockEntity {
    @Nullable
    private AABB aabb;
    public static SingleSlotAccess FILTER = new SingleSlotAccess();

    public ObeliskBlockEntity(EnergyIOMode energyIOMode, ICapacitorScalable capacity, ICapacitorScalable usageRate, BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(energyIOMode, capacity, usageRate, type, worldPosition, blockState);
        this.rangeVisibleDataSlot = new BooleanNetworkDataSlot(this::isRangeVisible, b -> {
            this.rangeVisible = b;
        });
        this.addDataSlot(this.rangeVisibleDataSlot);
        this.range = 4;
        this.rangeDataSlot = new IntegerNetworkDataSlot(this::getRange, r -> {
            this.range = r;
        }){

            @Override
            public void updateServerCallback() {
                ObeliskBlockEntity.this.updateLocations();
                ObeliskBlockEntity.this.m_6596_();
            }
        };
        this.addDataSlot(this.rangeDataSlot);
    }

    @Override
    protected boolean isActive() {
        return this.canAct();
    }

    public void setRangedActionData(int range, boolean rangeVisible) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.clientUpdateSlot(this.rangeVisibleDataSlot, rangeVisible);
            this.clientUpdateSlot(this.rangeDataSlot, range);
        } else {
            this.internalSetRangedActionData(range, rangeVisible);
        }
    }

    private void internalSetRangedActionData(int actionRange, boolean actionRangeVisible) {
        this.range = actionRange;
        this.rangeVisible = actionRangeVisible;
        this.updateLocations();
        this.m_6596_();
    }

    @Override
    public void serverTick() {
        this.updateMachineState(MachineState.ACTIVE, this.isActive());
        super.serverTick();
    }

    @Override
    public void clientTick() {
        Level level = this.f_58857_;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (!this.rangeVisible) {
                return;
            }
            BlockPos pos = this.m_58899_();
            if (clientLevel.m_5776_()) {
                clientLevel.m_6485_((ParticleOptions)new RangeParticleData(this.range, this.getColor()), true, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
            }
        }
        super.clientTick();
    }

    @Override
    public abstract String getColor();

    @Nullable
    public AABB getAABB() {
        return this.aabb;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateLocations();
    }

    protected void updateLocations() {
        this.aabb = new AABB(this.m_58899_()).m_82400_((double)this.getRange());
    }

    @Override
    protected IIOConfig createIOConfig() {
        return new SidedFixedIOConfig(dir -> IOMode.PULL);
    }
}

