/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.EnderIO;
import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.api.io.IIOConfig;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import java.util.EnumMap;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class MachineFluidHandler
implements IFluidHandler,
IEnderCapabilityProvider<IFluidHandler>,
INBTSerializable<CompoundTag> {
    public static final String TANK_INDEX = "Index";
    public static final String TANKS = "Tanks";
    public static final String TANK_LIST_SIZE = "Size";
    private final IIOConfig config;
    private final MachineTankLayout layout;
    private List<MachineFluidTank> tanks;
    private final EnumMap<Direction, LazyOptional<Sided>> sideCache = new EnumMap(Direction.class);
    private LazyOptional<MachineFluidHandler> selfCache = LazyOptional.empty();
    private IntConsumer changeListener = i -> {};

    public MachineFluidHandler(IIOConfig config, MachineTankLayout layout) {
        this.config = config;
        this.layout = layout;
        this.tanks = layout.createTanks();
    }

    public void addSlotChangedCallback(IntConsumer callback) {
        this.changeListener = this.changeListener.andThen(callback);
    }

    public final IIOConfig getConfig() {
        return this.config;
    }

    public MachineTankLayout getLayout() {
        return this.layout;
    }

    @Deprecated
    public final MachineFluidTank getTank(int tank) {
        return this.tanks.get(tank);
    }

    public int getTanks() {
        return this.layout.getTankCount();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tanks.get(tank).getFluid();
    }

    public void setFluidInTank(int tank, FluidStack fluid) {
        this.tanks.get(tank).setFluid(fluid);
    }

    public int getTankCapacity(int tank) {
        return this.layout.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.layout.isFluidValid(tank, stack);
    }

    @Override
    public Capability<IFluidHandler> getCapabilityType() {
        return ForgeCapabilities.FLUID_HANDLER;
    }

    @Override
    public LazyOptional<IFluidHandler> getCapability(@Nullable Direction side) {
        if (side == null) {
            if (!this.selfCache.isPresent()) {
                this.selfCache = LazyOptional.of(() -> this);
            }
            return this.selfCache.cast();
        }
        if (!this.config.getMode(side).canConnect()) {
            return LazyOptional.empty();
        }
        return this.sideCache.computeIfAbsent(side, dir -> LazyOptional.of(() -> new Sided(this, (Direction)dir))).cast();
    }

    @Override
    public void invalidateSide(@Nullable Direction side) {
        if (side != null) {
            if (this.sideCache.containsKey(side)) {
                this.sideCache.get(side).invalidate();
                this.sideCache.remove(side);
            }
        } else {
            this.selfCache.invalidate();
        }
    }

    @Override
    public void invalidateCaps() {
        for (LazyOptional<Sided> side : this.sideCache.values()) {
            side.invalidate();
        }
        this.selfCache.invalidate();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack resourceLeft = resource.copy();
        int totalFilled = 0;
        for (int index = 0; index < this.tanks.size(); ++index) {
            if (!this.layout.canInsert(index)) continue;
            int filled = this.tanks.get(index).fill(resourceLeft, action);
            resourceLeft.shrink(filled);
            totalFilled += filled;
            if (filled > 0) {
                this.onContentsChanged(index);
            }
            if (resourceLeft.isEmpty()) break;
        }
        return totalFilled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (int index = 0; index < this.tanks.size(); ++index) {
            if (!this.layout.canExtract(index) || this.tanks.get(index).drain(resource, IFluidHandler.FluidAction.SIMULATE) == FluidStack.EMPTY) continue;
            FluidStack drained = this.tanks.get(index).drain(resource, action);
            if (!drained.isEmpty()) {
                this.onContentsChanged(index);
                this.changeListener.accept(index);
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int index = 0; index < this.tanks.size(); ++index) {
            if (this.tanks.get(index).drain(maxDrain, IFluidHandler.FluidAction.SIMULATE) == FluidStack.EMPTY) continue;
            FluidStack drained = this.tanks.get(index).drain(maxDrain, action);
            if (!drained.isEmpty()) {
                this.onContentsChanged(index);
                this.changeListener.accept(index);
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    protected void onContentsChanged(int slot) {
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.tanks.size(); ++i) {
            CompoundTag tankTag = new CompoundTag();
            tankTag.m_128405_(TANK_INDEX, i);
            this.tanks.get(i).save(tankTag);
            nbtTagList.add((Object)tankTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(TANKS, (Tag)nbtTagList);
        nbt.m_128405_(TANK_LIST_SIZE, this.tanks.size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (!(nbt.m_128441_(TANK_LIST_SIZE) || nbt.m_128441_(TANKS) || nbt.m_128456_())) {
            if (!this.tanks.isEmpty()) {
                int capacity = this.layout.getTankCapacity(0);
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.tanks.set(0, new MachineFluidTank(fluidStack, capacity));
            } else {
                EnderIO.LOGGER.warn("Failed to load MachineFluidHandler tank contents.");
            }
        }
        if (nbt.m_128441_(TANK_LIST_SIZE)) {
            int size = nbt.m_128425_(TANK_LIST_SIZE, 3) ? nbt.m_128451_(TANK_LIST_SIZE) : this.tanks.size();
            this.tanks = NonNullList.m_122780_((int)size, (Object)MachineFluidTank.EMPTY);
            ListTag tagList = nbt.m_128437_(TANKS, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tankTag = tagList.m_128728_(i);
                int index = tankTag.m_128451_(TANK_INDEX);
                this.tanks.set(index, MachineFluidTank.from(tankTag));
            }
        }
    }

    private record Sided(MachineFluidHandler master, Direction direction) implements IFluidHandler
    {
        public int getTanks() {
            return this.master.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.master.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.master.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.master.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getMode(this.direction).canInput()) {
                return this.master.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getMode(this.direction).canOutput()) {
                return this.master.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getMode(this.direction).canOutput()) {
                return this.master.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

