/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.impl.ComposableModifier;
import slimeknights.tconstruct.library.utils.GenericTagUtil;

public class UpdateModifiersPacket
implements IThreadsafePacket {
    private final Map<ModifierId, Modifier> allModifiers;
    private final Map<TagKey<Modifier>, List<Modifier>> tags;
    private Collection<ComposableModifier> modifiers;
    private Map<ModifierId, ModifierId> redirects;
    private final Map<Enchantment, Modifier> enchantmentMap;
    private final Map<TagKey<Enchantment>, Modifier> enchantmentTagMappings;

    private void ensureCalculated() {
        if (this.modifiers == null || this.redirects == null) {
            ImmutableList.Builder modifiers = ImmutableList.builder();
            ImmutableMap.Builder redirects = ImmutableMap.builder();
            for (Map.Entry<ModifierId, Modifier> entry : this.allModifiers.entrySet()) {
                Modifier value;
                ModifierId actual;
                ModifierId id = entry.getKey();
                if (id.equals((Object)(actual = (value = entry.getValue()).getId()))) {
                    if (value instanceof ComposableModifier) {
                        ComposableModifier composable = (ComposableModifier)value;
                        modifiers.add((Object)composable);
                        continue;
                    }
                    TConstruct.LOG.warn("Unable to sync modifier {} as its not ComposableModifier; got class {}", (Object)id, (Object)value.getClass().getName());
                    continue;
                }
                redirects.put((Object)id, (Object)actual);
            }
            this.modifiers = modifiers.build();
            this.redirects = redirects.build();
        }
    }

    private static Modifier getModifier(Map<ModifierId, Modifier> modifiers, ModifierId id) {
        Modifier modifier = ModifierManager.INSTANCE.getStatic(id);
        if (modifier == ModifierManager.INSTANCE.getDefaultValue() && (modifier = modifiers.get((Object)id)) == null) {
            throw new DecoderException("Unknown modifier " + id);
        }
        return modifier;
    }

    public UpdateModifiersPacket(FriendlyByteBuf buffer) {
        int i;
        int size = buffer.m_130242_();
        HashMap<ModifierId, Modifier> modifiers = new HashMap<ModifierId, Modifier>();
        for (i = 0; i < size; ++i) {
            ModifierId id2 = new ModifierId(buffer.m_130136_(Short.MAX_VALUE));
            Modifier modifier = (Modifier)ComposableModifier.LOADER.decode(buffer, ModifierManager.createContext(id2));
            modifier.setId(id2);
            modifiers.put(id2, modifier);
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ModifierId from = new ModifierId(buffer.m_130136_(Short.MAX_VALUE));
            modifiers.put(from, UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.m_130136_(Short.MAX_VALUE))));
        }
        this.allModifiers = modifiers;
        this.tags = GenericTagUtil.decodeTags(buffer, ModifierManager.REGISTRY_KEY, id -> UpdateModifiersPacket.getModifier(modifiers, new ModifierId((ResourceLocation)id)));
        ImmutableMap.Builder enchantmentBuilder = ImmutableMap.builder();
        size = buffer.m_130242_();
        for (int i2 = 0; i2 < size; ++i2) {
            enchantmentBuilder.put((Object)((Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS)), (Object)UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.m_130281_())));
        }
        this.enchantmentMap = enchantmentBuilder.build();
        ImmutableMap.Builder enchantmentTagBuilder = ImmutableMap.builder();
        size = buffer.m_130242_();
        for (int i3 = 0; i3 < size; ++i3) {
            enchantmentTagBuilder.put((Object)TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)buffer.m_130281_()), (Object)UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.m_130281_())));
        }
        this.enchantmentTagMappings = enchantmentTagBuilder.build();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ensureCalculated();
        buffer.m_130130_(this.modifiers.size());
        for (ComposableModifier composableModifier : this.modifiers) {
            buffer.m_130085_((ResourceLocation)composableModifier.getId());
            ComposableModifier.LOADER.encode(buffer, (Object)composableModifier);
        }
        buffer.m_130130_(this.redirects.size());
        for (Map.Entry entry : this.redirects.entrySet()) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130085_((ResourceLocation)entry.getValue());
        }
        GenericTagUtil.encodeTags(buffer, Modifier::getId, this.tags);
        buffer.m_130130_(this.enchantmentMap.size());
        for (Map.Entry entry : this.enchantmentMap.entrySet()) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (Object)((Enchantment)entry.getKey()));
            buffer.m_130085_((ResourceLocation)((Modifier)entry.getValue()).getId());
        }
        buffer.m_130130_(this.enchantmentTagMappings.size());
        for (Map.Entry entry : this.enchantmentTagMappings.entrySet()) {
            buffer.m_130085_(((TagKey)entry.getKey()).f_203868_());
            buffer.m_130085_((ResourceLocation)((Modifier)entry.getValue()).getId());
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ModifierManager.INSTANCE.updateModifiersFromServer(this.allModifiers, this.tags, this.enchantmentMap, this.enchantmentTagMappings);
    }

    public UpdateModifiersPacket(Map<ModifierId, Modifier> allModifiers, Map<TagKey<Modifier>, List<Modifier>> tags, Map<Enchantment, Modifier> enchantmentMap, Map<TagKey<Enchantment>, Modifier> enchantmentTagMappings) {
        this.allModifiers = allModifiers;
        this.tags = tags;
        this.enchantmentMap = enchantmentMap;
        this.enchantmentTagMappings = enchantmentTagMappings;
    }
}

