/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class RecipeResult<T> {
    private static final RecipeResult<?> PASS = new RecipeResult(false);
    private final boolean success;

    public static <T> RecipeResult<T> pass() {
        return PASS;
    }

    public static <T> RecipeResult<T> success(@Nullable T result) {
        if (result == null) {
            return RecipeResult.pass();
        }
        return new Success<T>(result);
    }

    public static <T> RecipeResult<T> failure(Component component) {
        return new Failure(component);
    }

    public static <T> RecipeResult<T> failure(String translationKey, Object ... params) {
        return RecipeResult.failure((Component)Component.m_237110_((String)translationKey, (Object[])params));
    }

    public T getResult() {
        throw new UnsupportedOperationException("Cannot get result on failure");
    }

    public boolean hasError() {
        return false;
    }

    public Component getMessage() {
        throw new UnsupportedOperationException("Cannot show error message on success");
    }

    private RecipeResult(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private static class Success<T>
    extends RecipeResult<T> {
        private final T result;

        private Success(T result) {
            super(true);
            this.result = result;
        }

        @Override
        public T getResult() {
            return this.result;
        }
    }

    private static class Failure<T>
    extends RecipeResult<T> {
        private final Component message;

        private Failure(Component message) {
            super(false);
            this.message = message;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public Component getMessage() {
            return this.message;
        }
    }
}

