/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;

public class MeltingRecipeLookup {
    private static final List<MeltingFluid> FLUIDS = new ArrayList<MeltingFluid>();
    private static final Map<Item, MeltingFluid> LOOKUP = new HashMap<Item, MeltingFluid>();
    private static final RecipeCacheInvalidator.DuelSidedListener CACHE = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        FLUIDS.clear();
        LOOKUP.clear();
    });
    private static final Function<Item, MeltingFluid> LOOKUP_FUNCTION = item -> {
        if (item != Items.f_41852_) {
            ItemStack stack = new ItemStack((ItemLike)item);
            for (MeltingFluid fluid : FLUIDS) {
                if (!fluid.ingredient.test(stack)) continue;
                return fluid;
            }
        }
        return MeltingFluid.EMPTY;
    };

    private MeltingRecipeLookup() {
    }

    public static void addMeltingFluid(Ingredient ingredient, FluidOutput result, int temperature) {
        CACHE.checkClear();
        FLUIDS.add(new MeltingFluid(ingredient, result, temperature));
    }

    private static MeltingFluid findFluid(ItemLike item) {
        return LOOKUP.computeIfAbsent(item.m_5456_(), LOOKUP_FUNCTION);
    }

    public static FluidStack findResult(ItemLike input, int temperature) {
        MeltingFluid fluid = MeltingRecipeLookup.findFluid(input);
        if (fluid.temperature > temperature) {
            return FluidStack.EMPTY;
        }
        return fluid.result.get();
    }

    public static boolean canMelt(ItemLike input) {
        return !MeltingRecipeLookup.findFluid(input).isEmpty();
    }

    private record MeltingFluid(Ingredient ingredient, FluidOutput result, int temperature) {
        public static final MeltingFluid EMPTY = new MeltingFluid(Ingredient.f_43901_, FluidOutput.EMPTY, 0);

        public boolean isEmpty() {
            return this.result.isEmpty();
        }
    }
}

