/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.shared.client.ClientGeneratePartTexturesCommand;

public class GeneratePartTexturesPacket
implements IThreadsafePacket {
    private final Operation operation;
    private final String modId;
    private final String materialPath;

    public GeneratePartTexturesPacket(FriendlyByteBuf buffer) {
        this.operation = (Operation)buffer.m_130066_(Operation.class);
        this.modId = buffer.m_130136_(Short.MAX_VALUE);
        this.materialPath = buffer.m_130136_(Short.MAX_VALUE);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.operation);
        buffer.m_130070_(this.modId);
        buffer.m_130070_(this.materialPath);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientGeneratePartTexturesCommand.generateTextures(this.operation, this.modId, this.materialPath));
    }

    public GeneratePartTexturesPacket(Operation operation, String modId, String materialPath) {
        this.operation = operation;
        this.modId = modId;
        this.materialPath = materialPath;
    }

    public static enum Operation {
        ALL,
        MISSING;

    }
}

