/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blockentities;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.init.TGBlockEntities;
import com.lion.graveyard.init.TGSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class UrnBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            UrnBlockEntity.playSound(world, pos, state, TGSounds.URN_OPEN.get());
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            UrnBlockEntity.playSound(world, pos, state, TGSounds.URN_CLOSE.get());
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            UrnBlockEntity.this.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container inventory = ((ChestMenu)player.f_36096_).m_39261_();
            return inventory == UrnBlockEntity.this || inventory instanceof CompoundContainer && ((CompoundContainer)inventory).m_18927_((Container)UrnBlockEntity.this);
        }
    };

    public UrnBlockEntity(BlockPos pos, BlockState state) {
        super(TGBlockEntities.URN_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    public int m_6643_() {
        return 54;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.urn");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        boolean large = Graveyard.CONFIG.booleanEntries.get("urnHasDoubleInventory");
        if (large) {
            return ChestMenu.m_39246_((int)syncId, (Inventory)playerInventory, (Container)this);
        }
        return ChestMenu.m_39237_((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void onScheduledTick() {
        if (!this.f_58859_) {
            this.stateManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        Block block = state.m_60734_();
        world.m_7696_(pos, block, 1, newViewerCount);
    }

    static void playSound(Level world, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d = (double)pos.m_123341_() + 0.5;
        double e = (double)pos.m_123342_() + 0.5;
        double f = (double)pos.m_123343_() + 0.5;
        world.m_6263_((Player)null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

